package observability

import (
	"context"

	"code.justin.tv/eventbus/controlplane/internal/db"
	"go.uber.org/zap"
)

func (o *ObservabilityDB) EventTypeCreate(ctx context.Context, eventType *db.EventType) (int, error) {
	var err error
	var id int
	o.observe(ctx, "EventTypeCreate",
		func() ([]zap.Field, error) {
			id, err = o.db.EventTypeCreate(ctx, eventType)
			cpy := *eventType
			cpy.ID = id
			return []zap.Field{
				zap.Object("eventType", cpy),
			}, err
		})
	return id, err
}

func (o *ObservabilityDB) EventTypeUpdate(ctx context.Context, id int, eventTypeEditable *db.EventTypeEditable) (int, error) {
	var err error
	var retID int
	o.observe(ctx, "EventTypeUpdate",
		func() ([]zap.Field, error) {
			retID, err = o.db.EventTypeUpdate(ctx, id, eventTypeEditable)
			return []zap.Field{
				zap.Object("eventTypeUpdate", eventTypeEditable),
				zap.Int("eventTypeID", id),
			}, err
		})
	return retID, err
}

func (o *ObservabilityDB) EventTypes(ctx context.Context) ([]*db.EventType, error) {
	var err error
	var eventTypes []*db.EventType
	o.observe(ctx, "EventTypes",
		func() ([]zap.Field, error) {
			eventTypes, err = o.db.EventTypes(ctx)
			return []zap.Field{}, err
		})
	return eventTypes, err
}

func (o *ObservabilityDB) EventTypeByID(ctx context.Context, id int) (*db.EventType, error) {
	var err error
	var eventType *db.EventType
	o.observe(ctx, "EventTypeByID",
		func() ([]zap.Field, error) {
			eventType, err = o.db.EventTypeByID(ctx, id)
			return []zap.Field{
				zap.Int("eventTypeID", id),
			}, err
		})
	return eventType, err
}

func (o *ObservabilityDB) EventTypeByName(ctx context.Context, name string) (*db.EventType, error) {
	var err error
	var eventType *db.EventType
	o.observe(ctx, "EventTypeByName",
		func() ([]zap.Field, error) {
			eventType, err = o.db.EventTypeByName(ctx, name)
			return []zap.Field{
				zap.String("eventTypeName", name),
			}, err
		})
	return eventType, err
}

func (o *ObservabilityDB) EventTypeDeleteByName(ctx context.Context, name string) error {
	var err error
	o.observe(ctx, "EventTypeDeleteByName",
		func() ([]zap.Field, error) {
			err = o.db.EventTypeDeleteByName(ctx, name)
			return []zap.Field{
				zap.String("eventTypeName", name),
			}, err
		})
	return err
}
