package observability

import (
	"context"

	"code.justin.tv/eventbus/controlplane/internal/db"

	"go.uber.org/zap"
)

func (o *ObservabilityDB) FeatureFlagByName(ctx context.Context, name string) (*db.FeatureFlag, error) {
	var err error
	var res *db.FeatureFlag
	o.observe(ctx, "FeatureFlagByName",
		func() ([]zap.Field, error) {
			res, err = o.db.FeatureFlagByName(ctx, name)
			return []zap.Field{}, err
		})
	return res, err
}

func (o *ObservabilityDB) FeatureFlags(ctx context.Context) ([]*db.FeatureFlag, error) {
	var err error
	var res []*db.FeatureFlag
	o.observe(ctx, "FeatureFlagByName",
		func() ([]zap.Field, error) {
			res, err = o.db.FeatureFlags(ctx)
			return []zap.Field{}, err
		})
	return res, err
}

func (o *ObservabilityDB) FeatureFlagCreate(ctx context.Context, ff *db.FeatureFlag) (int, error) {
	var err error
	var id int
	o.observe(ctx, "FeatureFlagCreate",
		func() ([]zap.Field, error) {
			id, err = o.db.FeatureFlagCreate(ctx, ff)
			cpy := *ff
			cpy.ID = id
			return []zap.Field{
				zap.Object("featureFlag", cpy),
			}, err
		})
	return id, err
}

func (o *ObservabilityDB) FeatureFlagDelete(ctx context.Context, name string) error {
	var err error
	o.observe(ctx, "FeatureFlagDelete",
		func() ([]zap.Field, error) {
			err = o.db.FeatureFlagDelete(ctx, name)
			return []zap.Field{
				zap.String("featureFlagName", name),
			}, err
		})
	return err
}

func (o *ObservabilityDB) FeatureFlagDisable(ctx context.Context, name string) error {
	var err error
	o.observe(ctx, "FeatureFlagDisable",
		func() ([]zap.Field, error) {
			err = o.db.FeatureFlagDisable(ctx, name)
			return []zap.Field{
				zap.String("featureFlagName", name),
			}, err
		})
	return err
}

func (o *ObservabilityDB) FeatureFlagEnable(ctx context.Context, name string) error {
	var err error
	o.observe(ctx, "FeatureFlagEnable",
		func() ([]zap.Field, error) {
			err = o.db.FeatureFlagEnable(ctx, name)
			return []zap.Field{
				zap.String("featureFlagName", name),
			}, err
		})
	return err
}
