package observability

import (
	"code.justin.tv/eventbus/controlplane/internal/db"
)

type ObservabilityDB struct {
	db             db.DB
	loggingEnabled bool
	metricsEnabled bool
}

func WithLogging(db db.DB) *ObservabilityDB {
	obsDB := copyOrCreate(db)
	obsDB.loggingEnabled = true
	return obsDB
}

func WithMetrics(db db.DB) *ObservabilityDB {
	obsDB := copyOrCreate(db)
	obsDB.metricsEnabled = true
	return obsDB
}

func copyOrCreate(db db.DB) *ObservabilityDB {
	obsDB, ok := db.(*ObservabilityDB)
	if !ok {
		// make new obsDB
		obsDB = &ObservabilityDB{
			db: db,
		}
	}
	return obsDB
}
