package observability

import (
	"testing"

	"code.justin.tv/eventbus/controlplane/internal/db"
	"code.justin.tv/eventbus/controlplane/internal/db/mocks"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/suite"
)

type ObservabilityConstructorTest struct {
	suite.Suite
	db db.DB
}

func (suite *ObservabilityConstructorTest) SetupTest() {
	suite.db = &mocks.DB{}
}

func (suite *ObservabilityConstructorTest) TestWithLogging() {
	t := suite.T()
	_, isObsDB := suite.db.(*ObservabilityDB)
	assert.False(t, isObsDB)
	suite.db = WithLogging(suite.db)
	obsDB, isObsDB := suite.db.(*ObservabilityDB)
	assert.True(t, isObsDB)
	assert.True(t, obsDB.loggingEnabled)
	assert.False(t, obsDB.metricsEnabled)
}

func (suite *ObservabilityConstructorTest) TestWithMetrics() {
	t := suite.T()
	_, isObsDB := suite.db.(*ObservabilityDB)
	assert.False(t, isObsDB)
	suite.db = WithMetrics(suite.db)
	obsDB, isObsDB := suite.db.(*ObservabilityDB)
	assert.True(t, isObsDB)
	assert.False(t, obsDB.loggingEnabled)
	assert.True(t, obsDB.metricsEnabled)
}

func (suite *ObservabilityConstructorTest) TestWithLoggingAndMetrics() {
	t := suite.T()
	_, isObsDB := suite.db.(*ObservabilityDB)
	assert.False(t, isObsDB)
	suite.db = WithLogging(suite.db)
	suite.db = WithMetrics(suite.db)
	obsDB, isObsDB := suite.db.(*ObservabilityDB)
	assert.True(t, isObsDB)
	assert.True(t, obsDB.loggingEnabled)
	assert.True(t, obsDB.metricsEnabled)
}

func TestObservabilityDBConstructors(t *testing.T) {
	suite.Run(t, new(ObservabilityConstructorTest))
}
