package observability

import (
	"context"

	"code.justin.tv/eventbus/controlplane/internal/db"
	"go.uber.org/zap"
)

func (o *ObservabilityDB) PublicationCreate(ctx context.Context, publication *db.Publication) (int, error) {
	var err error
	var id int
	o.observe(ctx, "PublicationCreate",
		func() ([]zap.Field, error) {
			id, err = o.db.PublicationCreate(ctx, publication)
			cpy := *publication
			cpy.ID = id
			return []zap.Field{
				zap.Object("publication", cpy),
			}, err
		})
	return id, err
}
func (o *ObservabilityDB) PublicationDelete(ctx context.Context, id int) error {
	var err error
	o.observe(ctx, "PublicationDelete",
		func() ([]zap.Field, error) {
			err = o.db.PublicationDelete(ctx, id)
			return []zap.Field{
				zap.Int("publicationID", id),
			}, err
		})
	return err
}
func (o *ObservabilityDB) PublicationDeleteByEventStreamID(ctx context.Context, eventStreamID int) error {
	var err error
	o.observe(ctx, "PublicationDeleteByEventStreamID",
		func() ([]zap.Field, error) {
			err = o.db.PublicationDeleteByEventStreamID(ctx, eventStreamID)
			return []zap.Field{
				zap.Int("eventStreamID", eventStreamID),
			}, err
		})
	return err
}
func (o *ObservabilityDB) Publications(ctx context.Context) ([]*db.Publication, error) {
	var err error
	var pubs []*db.Publication
	o.observe(ctx, "Publications",
		func() ([]zap.Field, error) {
			pubs, err = o.db.Publications(ctx)
			return []zap.Field{}, err
		})
	return pubs, err
}
func (o *ObservabilityDB) PublicationsByServiceID(ctx context.Context, serviceID int) ([]*db.Publication, error) {
	var err error
	var pubs []*db.Publication
	o.observe(ctx, "PublicationsByServiceID",
		func() ([]zap.Field, error) {
			pubs, err = o.db.PublicationsByServiceID(ctx, serviceID)
			return []zap.Field{
				zap.Int("serviceID", serviceID),
			}, err
		})
	return pubs, err
}
func (o *ObservabilityDB) PublicationsByEventStreamID(ctx context.Context, eventStreamID int) ([]*db.Publication, error) {
	var err error
	var pubs []*db.Publication
	o.observe(ctx, "PublicationsByEventStreamID",
		func() ([]zap.Field, error) {
			pubs, err = o.db.PublicationsByEventStreamID(ctx, eventStreamID)
			return []zap.Field{
				zap.Int("eventStreamID", eventStreamID),
			}, err
		})
	return pubs, err
}
func (o *ObservabilityDB) PublicationsByIAMRoleID(ctx context.Context, iamRoleID int) ([]*db.Publication, error) {
	var err error
	var pubs []*db.Publication
	o.observe(ctx, "PublicationsByIAMRoleID",
		func() ([]zap.Field, error) {
			pubs, err = o.db.PublicationsByIAMRoleID(ctx, iamRoleID)
			return []zap.Field{
				zap.Int("iamRoleID", iamRoleID),
			}, err
		})
	return pubs, err
}
