package observability

import (
	"context"

	"code.justin.tv/eventbus/controlplane/internal/db"
	"go.uber.org/zap"
)

func (o *ObservabilityDB) ServiceCreate(ctx context.Context, service *db.Service) (int, error) {
	var err error
	var id int
	o.observe(ctx, "ServiceCreate",
		func() ([]zap.Field, error) {
			id, err = o.db.ServiceCreate(ctx, service)
			cpy := *service
			cpy.ID = id
			return []zap.Field{
				zap.Object("service", cpy),
			}, err
		})
	return id, err
}
func (o *ObservabilityDB) ServiceUpdate(ctx context.Context, id int, serviceEditable *db.ServiceEditable) (int, error) {
	var err error
	var retID int
	o.observe(ctx, "ServiceUpdate",
		func() ([]zap.Field, error) {
			retID, err = o.db.ServiceUpdate(ctx, id, serviceEditable)
			return []zap.Field{
				zap.Int("serviceID", id),
				zap.Object("serviceUpdate", serviceEditable),
			}, err
		})
	return retID, err
}
func (o *ObservabilityDB) ServiceDelete(ctx context.Context, id int) error {
	var err error
	o.observe(ctx, "ServiceDelete",
		func() ([]zap.Field, error) {
			err = o.db.ServiceDelete(ctx, id)
			return []zap.Field{
				zap.Int("serviceID", id),
			}, err
		})
	return err
}
func (o *ObservabilityDB) Services(ctx context.Context) ([]*db.Service, error) {
	var err error
	var svcs []*db.Service
	o.observe(ctx, "Services",
		func() ([]zap.Field, error) {
			svcs, err = o.db.Services(ctx)
			return []zap.Field{}, err
		})
	return svcs, err
}
func (o *ObservabilityDB) ServiceByID(ctx context.Context, id int) (*db.Service, error) {
	var err error
	var svc *db.Service
	o.observe(ctx, "ServiceByID",
		func() ([]zap.Field, error) {
			svc, err = o.db.ServiceByID(ctx, id)
			return []zap.Field{
				zap.Int("serviceID", id),
			}, err
		})
	return svc, err
}
func (o *ObservabilityDB) ServiceByServiceCatalogID(ctx context.Context, id string) (*db.Service, error) {
	var err error
	var svc *db.Service
	o.observe(ctx, "ServiceByServiceCatalogID",
		func() ([]zap.Field, error) {
			svc, err = o.db.ServiceByServiceCatalogID(ctx, id)
			return []zap.Field{
				zap.String("serviceCatalogID", id),
			}, err
		})
	return svc, err
}
func (o *ObservabilityDB) ServicesByLDAPGroup(ctx context.Context, ldap string) ([]*db.Service, error) {
	var err error
	var svcs []*db.Service
	o.observe(ctx, "ServicesByLDAPGroup",
		func() ([]zap.Field, error) {
			svcs, err = o.db.ServicesByLDAPGroup(ctx, ldap)
			return []zap.Field{
				zap.String("ldapGroup", ldap),
			}, err
		})
	return svcs, err
}

func (o *ObservabilityDB) ServicesWithIAMRoles(ctx context.Context) ([]*db.Service, error) {
	var err error
	var svcs []*db.Service
	o.observe(ctx, "ServicesWithIAMRoles",
		func() ([]zap.Field, error) {
			svcs, err = o.db.ServicesWithIAMRoles(ctx)
			return []zap.Field{}, err
		})
	return svcs, err
}
