CREATE TABLE subscription_targets (
    id SERIAL,
    service_id INTEGER NOT NULL,
    account_id INTEGER NOT NULL,
    name VARCHAR (128) NOT NULL,
    assume_role_arn VARCHAR (2048) NOT NULL,
    sqs_queue_arn VARCHAR (200) NOT NULL,
    status VARCHAR (64) NOT NULL,
    error TEXT NOT NULL,
    aws_lease_id INTEGER,

    PRIMARY KEY (id),
    CONSTRAINT subscription_targets_service_id_fkey FOREIGN KEY (service_id) REFERENCES services (id)
        ON UPDATE CASCADE,
     CONSTRAINT subscription_targets_account_id_fkey FOREIGN KEY (account_id) REFERENCES accounts (id)
        ON UPDATE CASCADE,
    CONSTRAINT subscription_targets_lease_id_fkey FOREIGN KEY (aws_lease_id) REFERENCES aws_leases (id)
        ON UPDATE CASCADE
);
