/*
* Reverse the following actions
* 1. Rename table from authorized_field_grants --> authorized_field_subscriber_grants
* 2. Remove the foreign key constraint on account_id --> accounts table
* 3. Rename column account_id --> environment_id
* 4. Add foreign key constraint on environment_id --> environments table
* 5. Rename constraint on authorized_field to match table name consistency
*
* TODO: deal with uniqueness constraint involving account_id?
*/
ALTER TABLE authorized_field_subscriber_grants
RENAME CONSTRAINT authorized_field_subscriber_grants_authorized_field_id_environment_id_key TO authorized_field_grants_authorized_field_id_account_id_key;

ALTER TABLE authorized_field_subscriber_grants
RENAME CONSTRAINT authorized_field_subscriber_grants_authorized_field_id_fkey TO authorized_field_grants_authorized_field_id_fkey;

ALTER TABLE authorized_field_subscriber_grants
DROP CONSTRAINT authorized_field_subscriber_grants_environment_id_fkey;

ALTER TABLE authorized_field_subscriber_grants
RENAME COLUMN environment_id TO account_id;

ALTER TABLE authorized_field_subscriber_grants
ADD CONSTRAINT authorized_field_grants_account_id_fkey FOREIGN KEY (account_id) REFERENCES accounts (id)
ON UPDATE CASCADE;

ALTER TABLE authorized_field_subscriber_grants RENAME TO authorized_field_grants;

