CREATE TABLE authorized_field_publisher_grants (
    id SERIAL PRIMARY KEY,
    event_stream_id INTEGER NOT NULL, -- Publishers can access all authorized fields associated with this event_stream
    environment_id INTEGER NOT NULL,

    CONSTRAINT authorized_field_publisher_grants_event_stream_id_fkey FOREIGN KEY (event_stream_id) REFERENCES event_streams (id)
        ON UPDATE CASCADE,
    CONSTRAINT authorized_field_publisher_grants_environment_id_fkey FOREIGN KEY (environment_id) REFERENCES environments (id)
        ON UPDATE CASCADE,
    UNIQUE (event_stream_id, environment_id)
);