package environment

import (
	"strings"

	"code.justin.tv/eventbus/controlplane/internal/e2eaccounts"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/credentials"
	"github.com/aws/aws-sdk-go/aws/endpoints"
)

// AWSConfig sets up a core aws.Config structure based
// on the runtime environment. This should be used only
// once per app initialization. Knows the difference between
// local, e2e testing, and staging/prod runtimes
func (c Config) AWSConfig() *aws.Config {
	conf := aws.NewConfig()
	if strings.HasPrefix(c.Environment, "local") {
		conf = conf.WithEndpoint(c.AWSEndpoint)
		conf = conf.WithCredentials(credentials.NewStaticCredentials("AKIAFAKE", "ABCDEFG", "ABCD"))
		conf = conf.WithS3ForcePathStyle(true)
	} else if strings.HasPrefix(c.Environment, "e2e") {
		conf = conf.WithCredentials(e2eaccounts.AccountCredentials().MainAccount)
		conf = conf.WithSTSRegionalEndpoint(endpoints.RegionalSTSEndpoint)
	} else {
		conf = conf.WithSTSRegionalEndpoint(endpoints.RegionalSTSEndpoint)
	}
	return conf
}
