package environment

import (
	"log"
	"os"
	"strings"
)

const LocalEnvironmentPrefix = "local"

func Environment() string {
	envName := os.Getenv("ENVIRONMENT")
	if envName == "" {
		log.Printf("No environment variable set, setting environment to %s", LocalEnvironmentPrefix)
		return LocalEnvironmentPrefix
	}
	return envName
}

func IsLocalDev() bool {
	env := Environment()
	return strings.HasPrefix(env, LocalEnvironmentPrefix)
}

func IsEndToEndTest() bool {
	return Environment() == "e2e-test"
}

func IsStagingEnv(envName string) bool {
	return envName == "staging"
}

func IsProductionEnv(envName string) bool {
	return envName == "prod" || envName == "production"
}
