package environment

import (
	"github.com/pkg/errors"
)

const (
	Production  = "production"
	Staging     = "staging"
	Development = "development"
)

var deployments = map[string]string{
	Production:  "https://eventbus.internal.justin.tv/",
	Staging:     "https://eventbus-staging.internal.justin.tv/",
	Development: "http://localhost:8888",
}

func IsValid(env string) bool {
	return IsProductionEnv(env) || IsStagingEnv(env) || IsLocalDev() || IsEndToEndTest()
}

// ValidEnvironments returns the list of supported environments within the controlplane
func ValidEnvironments() []string {
	return []string{Production, Staging, Development}
}

func Deployment(env string) (string, error) {
	if deployment, ok := deployments[env]; ok {
		return deployment, nil
	}
	return "", errors.New("could not get deployment for env " + env)
}
