package featureflags

import (
	"context"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/mock"
	"github.com/stretchr/testify/require"
	"github.com/twitchtv/twirp"

	dbMocks "code.justin.tv/eventbus/controlplane/internal/db/mocks"
	"code.justin.tv/eventbus/controlplane/internal/ldap"
	"code.justin.tv/eventbus/controlplane/rpc"
)

func dummyContext() (context.Context, context.CancelFunc) {
	ctx := context.Background()
	ctx = ldap.WithGroups(ctx, []string{"team-eventbus"})
	ctx = ldap.WithUser(ctx, "cooluser")
	return context.WithCancel(ctx)
}

func TestFeatureFlags(t *testing.T) {
	mockDB := &dbMocks.DB{}
	mockDB.On("FeatureFlagDelete", mock.Anything, mock.Anything).Return(nil)

	s := FeatureFlagsService{
		DB: mockDB,
	}

	ctx, cancel := dummyContext()
	defer cancel()

	t.Run("Delete", func(t *testing.T) {
		t.Run("non-empty name", func(t *testing.T) {
			req := &rpc.DeleteFeatureFlagsReq{
				Name: "nonempty",
			}
			_, err := s.Delete(ctx, req)
			require.NoError(t, err)
		})

		t.Run("empty name", func(t *testing.T) {
			req := &rpc.DeleteFeatureFlagsReq{
				Name: "",
			}
			_, err := s.Delete(ctx, req)
			assert.Error(t, err)
			assert.Equal(t, twirp.InvalidArgument, err.(twirp.Error).Code())
		})
	})
}
