package ldap

import (
	"context"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestContext(t *testing.T) {
	ctx := context.Background()

	ldapUser := "cooluser"
	ldapGroups := []string{"cool-group-1", "cool-group-2", "cool-group-3"}

	t.Run("WithUser", func(t *testing.T) {
		ctx = WithUser(ctx, ldapUser)
		assert.Equal(t, ldapUser, ctx.Value(ldapUserKey))
	})

	t.Run("User", func(t *testing.T) {
		assert.Equal(t, ldapUser, User(ctx))
	})

	t.Run("WithGroups", func(t *testing.T) {
		ctx = WithGroups(ctx, ldapGroups)
		assert.Equal(t, ldapGroups, ctx.Value(ldapGroupsKey))
	})

	t.Run("Groups", func(t *testing.T) {
		assert.Equal(t, ldapGroups, Groups(ctx))
	})
}
