package logger

import (
	"code.justin.tv/eventbus/controlplane/internal/ecs"
	"go.uber.org/zap/zapcore"
)

// container aliases the ecs.Container type to provide log marshalling capabilities.
type container ecs.Metadata

func (c container) MarshalLogObject(enc zapcore.ObjectEncoder) error {
	enc.AddString("availabilityZone", c.AvailabilityZone)
	enc.AddString("clusterName", c.ClusterName)
	enc.AddString("dockerName", c.DockerContainerName)
	enc.AddString("hostPublicIP", c.HostPublicIP)
	enc.AddString("id", c.ContainerID)
	enc.AddString("imageID", c.ImageID)
	enc.AddString("imageName", c.ImageName)
	enc.AddString("instanceARN", c.ContainerInstanceARN)
	enc.AddString("name", c.ContainerName)
	enc.AddString("taskARN", c.TaskARN)
	enc.AddString("taskFamily", c.TaskFamily)
	enc.AddString("taskRevision", c.TaskRevision)
	_ = enc.AddArray("portMappings", portMappings(c.PortMappings))
	return enc.AddArray("networks", networks(c.Networks))
}

type portMappings []ecs.PortMapping
type portMapping ecs.PortMapping

func (mm portMappings) MarshalLogArray(enc zapcore.ArrayEncoder) error {
	for _, m := range mm {
		_ = enc.AppendObject(portMapping(m))
	}
	return nil
}

func (m portMapping) MarshalLogObject(enc zapcore.ObjectEncoder) error {
	enc.AddString("bindIP", m.BindIP)
	enc.AddInt("containerPort", m.ContainerPort)
	enc.AddInt("hostPort", m.HostPort)
	enc.AddString("protocol", m.Protocol)
	return nil
}

type networks []ecs.Network
type network ecs.Network

func (nn networks) MarshalLogArray(enc zapcore.ArrayEncoder) error {
	for _, n := range nn {
		_ = enc.AppendObject(network(n))
	}
	return nil
}

func (n network) MarshalLogObject(enc zapcore.ObjectEncoder) error {
	enc.AddString("networkMode", n.NetworkMode)
	return enc.AddArray("ipv4Addresses", strings(n.IPv4Addresses))
}
