package logger

import (
	"context"

	"github.com/twitchtv/twirp"
	"go.uber.org/zap"
)

func TwirpErrorHook(ctx context.Context, err twirp.Error) context.Context {
	requestLogger := FromContext(ctx)
	code := err.Code()

	switch code {
	// Took any error codes that were roughly 4xx from https://github.com/twitchtv/twirp/blob/master/docs/errors.md#error-codes
	case twirp.NotFound, twirp.InvalidArgument, twirp.PermissionDenied, twirp.Unauthenticated, twirp.AlreadyExists, twirp.FailedPrecondition, twirp.ResourceExhausted, twirp.OutOfRange:
		requestLogger.Warn("client error", zap.String("twirpCode", string(code)), zap.Error(err))
	default:
		requestLogger.Error("twirp error", zap.String("twirpCode", string(code)), zap.Error(err))
	}
	return ctx
}
