package metrics

import (
	telemetry "code.justin.tv/amzn/TwitchTelemetry"
	middleware "code.justin.tv/amzn/TwitchTelemetryMetricsMiddleware"
	"code.justin.tv/eventbus/controlplane/internal/logger"
	"code.justin.tv/eventbus/fultonlog"
	"code.justin.tv/video/metrics-middleware/v2/awsmetric"
	"code.justin.tv/video/metrics-middleware/v2/operation"
	"github.com/aws/aws-sdk-go/aws/session"
)

// WithMetrics takes an AWS session struct and injects a middleware to observe metrics
// on calls to AWS operations.
func WithAWSMetrics(sess *session.Session, op string, l *logger.Logger) *session.Session {
	awsMetricClient := &awsmetric.Client{
		Starter: &operation.Starter{
			OpMonitors: []operation.OpMonitor{
				&middleware.OperationMonitor{
					SampleReporter: telemetry.SampleReporter{
						SampleObserver: Observer(),
						SampleBuilder: telemetry.SampleBuilder{
							ProcessIdentifier: ProcessIdentifier(),
						},
						Logger: fultonlog.FromZapLogger(l.Logger),
					},
				},
			},
		},
	}
	return awsMetricClient.AddToSession(sess)
}
