package eventstreamstats

import (
	"context"
	"math/rand"
)

// RandomClient is used in local and development environments to generate
// real-looking statistics for event streams.
type RandomClient struct{}

// Fetch generates bogus event stream statistics
func (c *RandomClient) Fetch(ctx context.Context, topicARN string) (*EventStreamStatistics, error) {
	// roll a D10. On 1, return no data. Else, generate random numbers between 1 and 1000
	d := rand.Intn(10)
	if d == 0 {
		return &EventStreamStatistics{}, nil
	}
	// use a seed to get values that at least _look_ sane in a dev env
	seed := rand.Float64()
	min := seed * 100
	max := seed * 1000
	avg := seed * 500
	size := rand.Float64() * 1000
	return &EventStreamStatistics{
		MaxEventsPerMinute:   &max,
		MinEventsPerMinute:   &min,
		MeanEventsPerMinute:  &avg,
		MeanEventPayloadSize: &size,
	}, nil
}
