package eventstreamstats

import "context"

// EventStreamStatistics contains data about usage for a single EventStream
type EventStreamStatistics struct {
	MaxEventsPerMinute   *float64
	MinEventsPerMinute   *float64
	MeanEventsPerMinute  *float64
	MeanEventPayloadSize *float64
}

// Fetcher interface for fetching statistics about an event stream
type Fetcher interface {
	Fetch(context.Context, string) (*EventStreamStatistics, error)
}
