package metrics

import (
	"time"

	"go.uber.org/zap"

	telemetry "code.justin.tv/amzn/TwitchTelemetry"
	poller "code.justin.tv/amzn/TwitchTelemetryPollingCollector"

	"code.justin.tv/eventbus/fultonlog"
)

var goStatsPoller *poller.PollingCollector

func StartGoStatsCollection(l *zap.Logger) {
	if goStatsPoller == nil {
		sampleBuilder := &telemetry.SampleBuilder{ProcessIdentifier: ProcessIdentifier()}
		goStatsPoller = poller.NewGoStatsPollingCollector(1*time.Minute, sampleBuilder, Observer(), fultonlog.FromZapLogger(l))
	}
	goStatsPoller.Start()
}
