package metrics

import (
	"errors"

	identifier "code.justin.tv/amzn/TwitchProcessIdentifier"
	"code.justin.tv/eventbus/controlplane/internal/environment"
)

const (
	Region   = "us-west-2"
	Substage = "primary"
)

// This is set in stone and never changes
var processIdentifier identifier.ProcessIdentifier
var processIdentifierSet bool

func init() {
	processIdentifierSet = false
	processIdentifier = identifier.ProcessIdentifier{
		Service:  "UNKNOWN",
		Region:   "",
		Stage:    "",
		Substage: "",
	}
}

func InitializeProcessIdentifier(service string) error {
	if processIdentifierSet {
		return errors.New("process identifier already set")
	}
	stage := environment.Environment()
	processIdentifier = identifier.ProcessIdentifier{
		Service:  service,
		Region:   Region,
		Stage:    stage,
		Substage: Substage,
	}
	processIdentifierSet = true
	return nil
}

func ProcessIdentifier() identifier.ProcessIdentifier {
	return processIdentifier
}
