package metrics

import (
	"github.com/twitchtv/twirp"

	telemetry "code.justin.tv/amzn/TwitchTelemetry"
	metricsmiddleware "code.justin.tv/amzn/TwitchTelemetryMetricsMiddleware"
	"code.justin.tv/video/metrics-middleware/v2/operation"
	"code.justin.tv/video/metrics-middleware/v2/twirpmetric"
)

// TwirpMiddleware returns a twirp ServerHook that can be plugged into Twirp APIs
// to get CloudWatch metrics
func TwirpMiddleware(api string) *twirp.ServerHooks {
	sampleObserver := Observer()
	sampleBuilder := telemetry.SampleBuilder{ProcessIdentifier: ProcessIdentifier()}
	sampleBuilder.Dimensions = make(telemetry.DimensionSet)
	// TODO: not currently able to get metrics rolled up for a particular twirp server
	// e.g. aggregated metrics for "targets" API... since no way to specify that rollup here
	sampleBuilder.Dimensions["API"] = api
	sampleReporter := telemetry.SampleReporter{
		SampleBuilder:  sampleBuilder,
		SampleObserver: sampleObserver,
	}

	// Create a middleware for twirp
	metricsOpMonitor := &metricsmiddleware.OperationMonitor{
		SampleReporter: sampleReporter,
		AutoFlush:      false,
	}
	opStarter := &operation.Starter{OpMonitors: []operation.OpMonitor{metricsOpMonitor}}
	metricsMiddleware := &twirpmetric.Server{Starter: opStarter}
	twirpMiddleware := twirp.ChainHooks(metricsMiddleware.ServerHooks())
	return twirpMiddleware
}
