package secrets

import (
	"fmt"
)

func (m *Manager) PostgresPassword() (string, error) {
	secretName := fmt.Sprintf("eventbus/controlplane/%s/postgres_writer_password", m.Env)
	return m.string(secretName)
}

func (m *Manager) PostgresUsername() (string, error) {
	secretName := fmt.Sprintf("eventbus/controlplane/%s/postgres_writer_username", m.Env)
	return m.string(secretName)
}

func (m *Manager) PostgresReaderUsername() (string, error) {
	secretName := fmt.Sprintf("eventbus/controlplane/%s/postgres_reader_username", m.Env)
	return m.string(secretName)
}

func (m *Manager) PostgresReaderPassword() (string, error) {
	secretName := fmt.Sprintf("eventbus/controlplane/%s/postgres_reader_password", m.Env)
	return m.string(secretName)
}
