package secrets

import (
	"code.justin.tv/systems/sandstorm/manager"
	"github.com/pkg/errors"
)

type Manager struct {
	*manager.Manager
	Env string
}

func (m *Manager) string(secretName string) (string, error) {
	secret, err := m.Get(secretName)
	if err != nil {
		return "", errors.Wrapf(err, "failed to retrieve secret %q", secretName)
	}
	return string(secret.Plaintext), nil
}
