package slugs

import (
	"strings"

	"github.com/gosimple/slug"
)

// Slugify converts the string into a slug. If `limit` is >0, then the resulting
// slug will be capped to at most `limit` characters
func Slugify(str string, limit int) string {
	slugged := slug.Make(str)
	if limit > 0 && len(slugged) > limit {
		slugged = slugged[0:limit]
	}
	return strings.Trim(slugged, "-_")
}
