package slugs

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestSlugify(t *testing.T) {
	s1 := "amazing Cool string"
	n1a := 300
	n1b := 4
	n1c := 0
	assert.Equal(t, "amazing-cool-string", Slugify(s1, n1a))
	assert.Equal(t, "amaz", Slugify(s1, n1b))
	assert.Equal(t, "amazing-cool-string", Slugify(s1, n1c))

	s2 := "WhatHappensWhenCamelCasing"
	n2a := 5
	n2b := -4
	n2c := 50
	assert.Equal(t, "whath", Slugify(s2, n2a))
	assert.Equal(t, "whathappenswhencamelcasing", Slugify(s2, n2b))
	assert.Equal(t, "whathappenswhencamelcasing", Slugify(s2, n2c))

	s3 := "  Trim Leading and Trailing Whitespace  "
	n3a := -1
	n3b := 5 // would be 'trim-' but gets reduced to 'trim'
	assert.Equal(t, "trim-leading-and-trailing-whitespace", Slugify(s3, n3a))
	assert.Equal(t, "trim", Slugify(s3, n3b))
}
