package sqsutil

import (
	"encoding/json"
)

type RedrivePolicy struct {
	DeadletterTargetARN string `json:"deadLetterTargetArn"`
	MaxReceiveCount     int    `json:"maxReceiveCount"`
}

func (p *RedrivePolicy) ToStringAttribute() (string, error) {
	buf, err := json.Marshal(p)
	if err != nil {
		return "", err
	}
	return string(buf), nil
}

// Parse a redrive policy. Returns nil with no error if input is empty string.
func ParseRedrivePolicy(input string) (*RedrivePolicy, error) {
	if input == "" || input == "None" {
		return nil, nil
	}

	var dest RedrivePolicy
	err := json.Unmarshal([]byte(input), &dest)
	if err != nil {
		return nil, err
	}

	return &dest, nil
}
