package sqsutil

import (
	"net/url"
	"strings"

	"github.com/pkg/errors"
)

func AccountIDFromQueueURL(queueURL string) (string, error) {
	u, err := url.Parse(queueURL)
	if err != nil {
		return "", errors.Wrap(err, "invalid URL")
	}
	parts := strings.Split(strings.TrimLeft(u.Path, "/"), "/")
	if len(parts) != 2 {
		return "", errors.Errorf("Expected 2 parts, got %v", parts)
	}
	return parts[0], nil
}
