package mocks

import (
	"reflect"

	"code.justin.tv/eventbus/controlplane/internal/twirperr"
)

var _ twirperr.DBError = &DBError{}

var reasons []string

// This init will populate `reasons` with the names of the methods on the
// DBError interface, allowing calls to NewDBErrorFor to provide a method
// name on which to return `true` for, and `false` for all others
func init() {
	t := reflect.TypeOf((*twirperr.DBError)(nil)).Elem()
	for i := 0; i < t.NumMethod(); i++ {
		reasons = append(reasons, t.Method(i).Name)
	}
}

// Returns a DBError that returns false for all of the interface methods
// makes writing tests using this mock easier
func NewDBErrorFor(reason string) *DBError {
	m := &DBError{}

	for _, r := range reasons {
		t := false
		if reason == r {
			t = true
		}
		m.On(r).Return(t)
	}

	m.On("Error").Return("ERROR")

	return m
}
