package uuid

import (
	uuid "github.com/gofrs/uuid"
)

// NewUUID returns a freshly generated UUID
func NewUUID() (string, error) {
	u, err := uuid.NewV4()
	if err != nil {
		return "", err
	}

	return u.String(), nil
}

// NewUUIDMust returns a UUID as a string, or panics. Primarily for use in tests.
func NewUUIDMust() string {
	return uuid.Must(uuid.NewV4()).String()

}
