package validator

import (
	"regexp"
	"strings"
)

const (
	validIAMRoleARNRegex string = `^arn:aws:iam::\d{12}:role(\/[a-zA-Z0-9_+=,.@-]+)+$`
)

var (
	iamRoleARNValidator = regexp.MustCompile(validIAMRoleARNRegex)
)

func IsValidIAMRoleARN(arn string) bool {
	return iamRoleARNValidator.MatchString(arn)
}

func IsValidIAMRoleLabel(label string) bool {
	return len(label) < 64 && len(strings.TrimSpace(label)) != 0
}
