package validator_test

import (
	"testing"

	"code.justin.tv/eventbus/controlplane/internal/validator"
	"github.com/stretchr/testify/assert"
)

func TestIsValidVisibleASCII(t *testing.T) {
	tests := []struct {
		str      string
		expected bool
	}{
		{"abc def gh i JK lm - skjvbdfkv", true},
		{"!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[]^_`abcdefghijklmnopqrstuvwxyz{|}~", true},
		{string([]byte{65, 66, 67}), true},
		{string([]byte{126, 125, 100, 45, 32, 65, 66, 67, 32, 41}), true},

		{"", false},
		{string([]byte{0, 66, 67}), false},
		{string([]byte{19}), false},
		{string([]byte{127}), false},
	}

	for _, test := range tests {
		if test.expected {
			assert.True(t, validator.IsValidVisibleASCII(test.str), "expected valid service description %q", test.str)
		} else {
			assert.False(t, validator.IsValidVisibleASCII(test.str), "expected invalid service description %q", test.str)
		}
	}
}

func TestIsMultilineVisible(t *testing.T) {
	tests := []struct {
		str      string
		expected bool
	}{
		{"!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[]^_`abcdefghijklmnopqrstuvwxyz{|}~", true},
		{"multi\nline", true},
		{"", false},
		{"\xbd\xb2", false},
	}

	for _, test := range tests {
		if test.expected {
			assert.True(t, validator.IsMultilineVisible(test.str), "expected valid service description %q", test.str)
		} else {
			assert.False(t, validator.IsMultilineVisible(test.str), "expected invalid service description %q", test.str)
		}
	}
}
