// Code generated by protoc-gen-twirp v5.3.0, DO NOT EDIT.
// source: code.justin.tv/eventbus/controlplane/rpc/services.proto

package rpc

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// ==================
// Services Interface
// ==================

type Services interface {
	// List the services available in the system. Does not include statistics.
	List(context.Context, *ListServicesReq) (*ListServicesResp, error)

	// Get details of a single service
	Get(context.Context, *GetServiceReq) (*Service, error)

	// Create a service
	Create(context.Context, *CreateServiceReq) (*CreateServiceResp, error)

	// Update a service
	Update(context.Context, *UpdateServiceReq) (*UpdateServiceResp, error)

	// Get a service's authorized field grants
	GetAuthorizedFieldGrants(context.Context, *GetAuthorizedFieldGrantsReq) (*GetAuthorizedFieldGrantsResp, error)

	// Get requestor's LDAP groups
	RequestorLDAPGroups(context.Context, *RequestorLDAPGroupsReq) (*RequestorLDAPGroupsResp, error)

	// Get list of members of a given LDAP group
	ResolveLDAPGroupUsers(context.Context, *ResolveLDAPGroupUsersReq) (*ResolveLDAPGroupUsersResp, error)

	DeleteIAMRole(context.Context, *DeleteIAMRoleReq) (*DeleteIAMRoleResp, error)

	GetServicesForEventStream(context.Context, *GetServicesForEventStreamReq) (*GetServicesForEventStreamResp, error)

	GetCloudFormationVersion(context.Context, *GetCloudFormationVersionReq) (*GetCloudFormationVersionResp, error)

	CreateIAMRole(context.Context, *CreateIAMRoleReq) (*CreateIAMRoleResp, error)

	UpdateIAMRoleLabel(context.Context, *UpdateIAMRoleLabelReq) (*UpdateIAMRoleLabelResp, error)

	ValidateIAMRole(context.Context, *ValidateIAMRoleReq) (*ValidateIAMRoleResp, error)
}

// ========================
// Services Protobuf Client
// ========================

type servicesProtobufClient struct {
	client HTTPClient
	urls   [13]string
}

// NewServicesProtobufClient creates a Protobuf client that implements the Services interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewServicesProtobufClient(addr string, client HTTPClient) Services {
	prefix := urlBase(addr) + ServicesPathPrefix
	urls := [13]string{
		prefix + "List",
		prefix + "Get",
		prefix + "Create",
		prefix + "Update",
		prefix + "GetAuthorizedFieldGrants",
		prefix + "RequestorLDAPGroups",
		prefix + "ResolveLDAPGroupUsers",
		prefix + "DeleteIAMRole",
		prefix + "GetServicesForEventStream",
		prefix + "GetCloudFormationVersion",
		prefix + "CreateIAMRole",
		prefix + "UpdateIAMRoleLabel",
		prefix + "ValidateIAMRole",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &servicesProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &servicesProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *servicesProtobufClient) List(ctx context.Context, in *ListServicesReq) (*ListServicesResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Services")
	ctx = ctxsetters.WithMethodName(ctx, "List")
	out := new(ListServicesResp)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *servicesProtobufClient) Get(ctx context.Context, in *GetServiceReq) (*Service, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Services")
	ctx = ctxsetters.WithMethodName(ctx, "Get")
	out := new(Service)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *servicesProtobufClient) Create(ctx context.Context, in *CreateServiceReq) (*CreateServiceResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Services")
	ctx = ctxsetters.WithMethodName(ctx, "Create")
	out := new(CreateServiceResp)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

func (c *servicesProtobufClient) Update(ctx context.Context, in *UpdateServiceReq) (*UpdateServiceResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Services")
	ctx = ctxsetters.WithMethodName(ctx, "Update")
	out := new(UpdateServiceResp)
	err := doProtobufRequest(ctx, c.client, c.urls[3], in, out)
	return out, err
}

func (c *servicesProtobufClient) GetAuthorizedFieldGrants(ctx context.Context, in *GetAuthorizedFieldGrantsReq) (*GetAuthorizedFieldGrantsResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Services")
	ctx = ctxsetters.WithMethodName(ctx, "GetAuthorizedFieldGrants")
	out := new(GetAuthorizedFieldGrantsResp)
	err := doProtobufRequest(ctx, c.client, c.urls[4], in, out)
	return out, err
}

func (c *servicesProtobufClient) RequestorLDAPGroups(ctx context.Context, in *RequestorLDAPGroupsReq) (*RequestorLDAPGroupsResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Services")
	ctx = ctxsetters.WithMethodName(ctx, "RequestorLDAPGroups")
	out := new(RequestorLDAPGroupsResp)
	err := doProtobufRequest(ctx, c.client, c.urls[5], in, out)
	return out, err
}

func (c *servicesProtobufClient) ResolveLDAPGroupUsers(ctx context.Context, in *ResolveLDAPGroupUsersReq) (*ResolveLDAPGroupUsersResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Services")
	ctx = ctxsetters.WithMethodName(ctx, "ResolveLDAPGroupUsers")
	out := new(ResolveLDAPGroupUsersResp)
	err := doProtobufRequest(ctx, c.client, c.urls[6], in, out)
	return out, err
}

func (c *servicesProtobufClient) DeleteIAMRole(ctx context.Context, in *DeleteIAMRoleReq) (*DeleteIAMRoleResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Services")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteIAMRole")
	out := new(DeleteIAMRoleResp)
	err := doProtobufRequest(ctx, c.client, c.urls[7], in, out)
	return out, err
}

func (c *servicesProtobufClient) GetServicesForEventStream(ctx context.Context, in *GetServicesForEventStreamReq) (*GetServicesForEventStreamResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Services")
	ctx = ctxsetters.WithMethodName(ctx, "GetServicesForEventStream")
	out := new(GetServicesForEventStreamResp)
	err := doProtobufRequest(ctx, c.client, c.urls[8], in, out)
	return out, err
}

func (c *servicesProtobufClient) GetCloudFormationVersion(ctx context.Context, in *GetCloudFormationVersionReq) (*GetCloudFormationVersionResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Services")
	ctx = ctxsetters.WithMethodName(ctx, "GetCloudFormationVersion")
	out := new(GetCloudFormationVersionResp)
	err := doProtobufRequest(ctx, c.client, c.urls[9], in, out)
	return out, err
}

func (c *servicesProtobufClient) CreateIAMRole(ctx context.Context, in *CreateIAMRoleReq) (*CreateIAMRoleResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Services")
	ctx = ctxsetters.WithMethodName(ctx, "CreateIAMRole")
	out := new(CreateIAMRoleResp)
	err := doProtobufRequest(ctx, c.client, c.urls[10], in, out)
	return out, err
}

func (c *servicesProtobufClient) UpdateIAMRoleLabel(ctx context.Context, in *UpdateIAMRoleLabelReq) (*UpdateIAMRoleLabelResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Services")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateIAMRoleLabel")
	out := new(UpdateIAMRoleLabelResp)
	err := doProtobufRequest(ctx, c.client, c.urls[11], in, out)
	return out, err
}

func (c *servicesProtobufClient) ValidateIAMRole(ctx context.Context, in *ValidateIAMRoleReq) (*ValidateIAMRoleResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Services")
	ctx = ctxsetters.WithMethodName(ctx, "ValidateIAMRole")
	out := new(ValidateIAMRoleResp)
	err := doProtobufRequest(ctx, c.client, c.urls[12], in, out)
	return out, err
}

// ====================
// Services JSON Client
// ====================

type servicesJSONClient struct {
	client HTTPClient
	urls   [13]string
}

// NewServicesJSONClient creates a JSON client that implements the Services interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewServicesJSONClient(addr string, client HTTPClient) Services {
	prefix := urlBase(addr) + ServicesPathPrefix
	urls := [13]string{
		prefix + "List",
		prefix + "Get",
		prefix + "Create",
		prefix + "Update",
		prefix + "GetAuthorizedFieldGrants",
		prefix + "RequestorLDAPGroups",
		prefix + "ResolveLDAPGroupUsers",
		prefix + "DeleteIAMRole",
		prefix + "GetServicesForEventStream",
		prefix + "GetCloudFormationVersion",
		prefix + "CreateIAMRole",
		prefix + "UpdateIAMRoleLabel",
		prefix + "ValidateIAMRole",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &servicesJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &servicesJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *servicesJSONClient) List(ctx context.Context, in *ListServicesReq) (*ListServicesResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Services")
	ctx = ctxsetters.WithMethodName(ctx, "List")
	out := new(ListServicesResp)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *servicesJSONClient) Get(ctx context.Context, in *GetServiceReq) (*Service, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Services")
	ctx = ctxsetters.WithMethodName(ctx, "Get")
	out := new(Service)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *servicesJSONClient) Create(ctx context.Context, in *CreateServiceReq) (*CreateServiceResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Services")
	ctx = ctxsetters.WithMethodName(ctx, "Create")
	out := new(CreateServiceResp)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

func (c *servicesJSONClient) Update(ctx context.Context, in *UpdateServiceReq) (*UpdateServiceResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Services")
	ctx = ctxsetters.WithMethodName(ctx, "Update")
	out := new(UpdateServiceResp)
	err := doJSONRequest(ctx, c.client, c.urls[3], in, out)
	return out, err
}

func (c *servicesJSONClient) GetAuthorizedFieldGrants(ctx context.Context, in *GetAuthorizedFieldGrantsReq) (*GetAuthorizedFieldGrantsResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Services")
	ctx = ctxsetters.WithMethodName(ctx, "GetAuthorizedFieldGrants")
	out := new(GetAuthorizedFieldGrantsResp)
	err := doJSONRequest(ctx, c.client, c.urls[4], in, out)
	return out, err
}

func (c *servicesJSONClient) RequestorLDAPGroups(ctx context.Context, in *RequestorLDAPGroupsReq) (*RequestorLDAPGroupsResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Services")
	ctx = ctxsetters.WithMethodName(ctx, "RequestorLDAPGroups")
	out := new(RequestorLDAPGroupsResp)
	err := doJSONRequest(ctx, c.client, c.urls[5], in, out)
	return out, err
}

func (c *servicesJSONClient) ResolveLDAPGroupUsers(ctx context.Context, in *ResolveLDAPGroupUsersReq) (*ResolveLDAPGroupUsersResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Services")
	ctx = ctxsetters.WithMethodName(ctx, "ResolveLDAPGroupUsers")
	out := new(ResolveLDAPGroupUsersResp)
	err := doJSONRequest(ctx, c.client, c.urls[6], in, out)
	return out, err
}

func (c *servicesJSONClient) DeleteIAMRole(ctx context.Context, in *DeleteIAMRoleReq) (*DeleteIAMRoleResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Services")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteIAMRole")
	out := new(DeleteIAMRoleResp)
	err := doJSONRequest(ctx, c.client, c.urls[7], in, out)
	return out, err
}

func (c *servicesJSONClient) GetServicesForEventStream(ctx context.Context, in *GetServicesForEventStreamReq) (*GetServicesForEventStreamResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Services")
	ctx = ctxsetters.WithMethodName(ctx, "GetServicesForEventStream")
	out := new(GetServicesForEventStreamResp)
	err := doJSONRequest(ctx, c.client, c.urls[8], in, out)
	return out, err
}

func (c *servicesJSONClient) GetCloudFormationVersion(ctx context.Context, in *GetCloudFormationVersionReq) (*GetCloudFormationVersionResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Services")
	ctx = ctxsetters.WithMethodName(ctx, "GetCloudFormationVersion")
	out := new(GetCloudFormationVersionResp)
	err := doJSONRequest(ctx, c.client, c.urls[9], in, out)
	return out, err
}

func (c *servicesJSONClient) CreateIAMRole(ctx context.Context, in *CreateIAMRoleReq) (*CreateIAMRoleResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Services")
	ctx = ctxsetters.WithMethodName(ctx, "CreateIAMRole")
	out := new(CreateIAMRoleResp)
	err := doJSONRequest(ctx, c.client, c.urls[10], in, out)
	return out, err
}

func (c *servicesJSONClient) UpdateIAMRoleLabel(ctx context.Context, in *UpdateIAMRoleLabelReq) (*UpdateIAMRoleLabelResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Services")
	ctx = ctxsetters.WithMethodName(ctx, "UpdateIAMRoleLabel")
	out := new(UpdateIAMRoleLabelResp)
	err := doJSONRequest(ctx, c.client, c.urls[11], in, out)
	return out, err
}

func (c *servicesJSONClient) ValidateIAMRole(ctx context.Context, in *ValidateIAMRoleReq) (*ValidateIAMRoleResp, error) {
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Services")
	ctx = ctxsetters.WithMethodName(ctx, "ValidateIAMRole")
	out := new(ValidateIAMRoleResp)
	err := doJSONRequest(ctx, c.client, c.urls[12], in, out)
	return out, err
}

// =======================
// Services Server Handler
// =======================

type servicesServer struct {
	Services
	hooks *twirp.ServerHooks
}

func NewServicesServer(svc Services, hooks *twirp.ServerHooks) TwirpServer {
	return &servicesServer{
		Services: svc,
		hooks:    hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *servicesServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// ServicesPathPrefix is used for all URL paths on a twirp Services server.
// Requests are always: POST ServicesPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const ServicesPathPrefix = "/twirp/code.justin.tv.eventbus.controlplane.Services/"

func (s *servicesServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "code.justin.tv.eventbus.controlplane")
	ctx = ctxsetters.WithServiceName(ctx, "Services")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/code.justin.tv.eventbus.controlplane.Services/List":
		s.serveList(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.eventbus.controlplane.Services/Get":
		s.serveGet(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.eventbus.controlplane.Services/Create":
		s.serveCreate(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.eventbus.controlplane.Services/Update":
		s.serveUpdate(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.eventbus.controlplane.Services/GetAuthorizedFieldGrants":
		s.serveGetAuthorizedFieldGrants(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.eventbus.controlplane.Services/RequestorLDAPGroups":
		s.serveRequestorLDAPGroups(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.eventbus.controlplane.Services/ResolveLDAPGroupUsers":
		s.serveResolveLDAPGroupUsers(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.eventbus.controlplane.Services/DeleteIAMRole":
		s.serveDeleteIAMRole(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.eventbus.controlplane.Services/GetServicesForEventStream":
		s.serveGetServicesForEventStream(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.eventbus.controlplane.Services/GetCloudFormationVersion":
		s.serveGetCloudFormationVersion(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.eventbus.controlplane.Services/CreateIAMRole":
		s.serveCreateIAMRole(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.eventbus.controlplane.Services/UpdateIAMRoleLabel":
		s.serveUpdateIAMRoleLabel(ctx, resp, req)
		return
	case "/twirp/code.justin.tv.eventbus.controlplane.Services/ValidateIAMRole":
		s.serveValidateIAMRole(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *servicesServer) serveList(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *servicesServer) serveListJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "List")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ListServicesReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListServicesResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.List(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListServicesResp and nil error while calling List. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *servicesServer) serveListProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "List")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ListServicesReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ListServicesResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.List(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListServicesResp and nil error while calling List. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *servicesServer) serveGet(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *servicesServer) serveGetJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Get")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetServiceReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Service
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Get(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Service and nil error while calling Get. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *servicesServer) serveGetProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Get")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetServiceReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *Service
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Get(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *Service and nil error while calling Get. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *servicesServer) serveCreate(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *servicesServer) serveCreateJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Create")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateServiceReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateServiceResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Create(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateServiceResp and nil error while calling Create. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *servicesServer) serveCreateProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Create")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateServiceReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateServiceResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Create(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateServiceResp and nil error while calling Create. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *servicesServer) serveUpdate(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *servicesServer) serveUpdateJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Update")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateServiceReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateServiceResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Update(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateServiceResp and nil error while calling Update. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *servicesServer) serveUpdateProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "Update")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateServiceReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateServiceResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.Update(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateServiceResp and nil error while calling Update. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *servicesServer) serveGetAuthorizedFieldGrants(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetAuthorizedFieldGrantsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetAuthorizedFieldGrantsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *servicesServer) serveGetAuthorizedFieldGrantsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAuthorizedFieldGrants")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetAuthorizedFieldGrantsReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetAuthorizedFieldGrantsResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetAuthorizedFieldGrants(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAuthorizedFieldGrantsResp and nil error while calling GetAuthorizedFieldGrants. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *servicesServer) serveGetAuthorizedFieldGrantsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetAuthorizedFieldGrants")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetAuthorizedFieldGrantsReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetAuthorizedFieldGrantsResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetAuthorizedFieldGrants(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetAuthorizedFieldGrantsResp and nil error while calling GetAuthorizedFieldGrants. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *servicesServer) serveRequestorLDAPGroups(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveRequestorLDAPGroupsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveRequestorLDAPGroupsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *servicesServer) serveRequestorLDAPGroupsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RequestorLDAPGroups")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(RequestorLDAPGroupsReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *RequestorLDAPGroupsResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.RequestorLDAPGroups(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RequestorLDAPGroupsResp and nil error while calling RequestorLDAPGroups. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *servicesServer) serveRequestorLDAPGroupsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "RequestorLDAPGroups")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(RequestorLDAPGroupsReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *RequestorLDAPGroupsResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.RequestorLDAPGroups(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *RequestorLDAPGroupsResp and nil error while calling RequestorLDAPGroups. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *servicesServer) serveResolveLDAPGroupUsers(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveResolveLDAPGroupUsersJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveResolveLDAPGroupUsersProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *servicesServer) serveResolveLDAPGroupUsersJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ResolveLDAPGroupUsers")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ResolveLDAPGroupUsersReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ResolveLDAPGroupUsersResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ResolveLDAPGroupUsers(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ResolveLDAPGroupUsersResp and nil error while calling ResolveLDAPGroupUsers. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *servicesServer) serveResolveLDAPGroupUsersProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ResolveLDAPGroupUsers")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ResolveLDAPGroupUsersReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ResolveLDAPGroupUsersResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ResolveLDAPGroupUsers(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ResolveLDAPGroupUsersResp and nil error while calling ResolveLDAPGroupUsers. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *servicesServer) serveDeleteIAMRole(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteIAMRoleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteIAMRoleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *servicesServer) serveDeleteIAMRoleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteIAMRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(DeleteIAMRoleReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteIAMRoleResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteIAMRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteIAMRoleResp and nil error while calling DeleteIAMRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *servicesServer) serveDeleteIAMRoleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteIAMRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(DeleteIAMRoleReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *DeleteIAMRoleResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.DeleteIAMRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *DeleteIAMRoleResp and nil error while calling DeleteIAMRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *servicesServer) serveGetServicesForEventStream(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetServicesForEventStreamJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetServicesForEventStreamProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *servicesServer) serveGetServicesForEventStreamJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetServicesForEventStream")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetServicesForEventStreamReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetServicesForEventStreamResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetServicesForEventStream(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetServicesForEventStreamResp and nil error while calling GetServicesForEventStream. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *servicesServer) serveGetServicesForEventStreamProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetServicesForEventStream")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetServicesForEventStreamReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetServicesForEventStreamResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetServicesForEventStream(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetServicesForEventStreamResp and nil error while calling GetServicesForEventStream. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *servicesServer) serveGetCloudFormationVersion(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetCloudFormationVersionJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetCloudFormationVersionProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *servicesServer) serveGetCloudFormationVersionJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCloudFormationVersion")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetCloudFormationVersionReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetCloudFormationVersionResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetCloudFormationVersion(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCloudFormationVersionResp and nil error while calling GetCloudFormationVersion. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *servicesServer) serveGetCloudFormationVersionProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetCloudFormationVersion")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetCloudFormationVersionReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *GetCloudFormationVersionResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetCloudFormationVersion(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *GetCloudFormationVersionResp and nil error while calling GetCloudFormationVersion. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *servicesServer) serveCreateIAMRole(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateIAMRoleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateIAMRoleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *servicesServer) serveCreateIAMRoleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateIAMRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(CreateIAMRoleReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateIAMRoleResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateIAMRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateIAMRoleResp and nil error while calling CreateIAMRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *servicesServer) serveCreateIAMRoleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateIAMRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(CreateIAMRoleReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *CreateIAMRoleResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.CreateIAMRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *CreateIAMRoleResp and nil error while calling CreateIAMRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *servicesServer) serveUpdateIAMRoleLabel(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveUpdateIAMRoleLabelJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveUpdateIAMRoleLabelProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *servicesServer) serveUpdateIAMRoleLabelJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateIAMRoleLabel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UpdateIAMRoleLabelReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateIAMRoleLabelResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateIAMRoleLabel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateIAMRoleLabelResp and nil error while calling UpdateIAMRoleLabel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *servicesServer) serveUpdateIAMRoleLabelProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "UpdateIAMRoleLabel")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UpdateIAMRoleLabelReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *UpdateIAMRoleLabelResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.UpdateIAMRoleLabel(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *UpdateIAMRoleLabelResp and nil error while calling UpdateIAMRoleLabel. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *servicesServer) serveValidateIAMRole(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveValidateIAMRoleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveValidateIAMRoleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *servicesServer) serveValidateIAMRoleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ValidateIAMRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(ValidateIAMRoleReq)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ValidateIAMRoleResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ValidateIAMRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ValidateIAMRoleResp and nil error while calling ValidateIAMRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *servicesServer) serveValidateIAMRoleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ValidateIAMRole")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(ValidateIAMRoleReq)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ValidateIAMRoleResp
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ValidateIAMRole(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ValidateIAMRoleResp and nil error while calling ValidateIAMRole. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *servicesServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor4, 0
}

func (s *servicesServer) ProtocGenTwirpVersion() string {
	return "v5.3.0"
}

var twirpFileDescriptor4 = []byte{
	// 1171 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x58, 0x4f, 0x6f, 0x1b, 0x45,
	0x14, 0xd7, 0x3a, 0x69, 0x6d, 0xbf, 0xd0, 0xc6, 0x99, 0x34, 0x65, 0x63, 0x08, 0x8d, 0x56, 0x15,
	0xea, 0x05, 0x47, 0x4a, 0x04, 0x6d, 0x21, 0x6d, 0xc9, 0x5f, 0x93, 0x2a, 0x45, 0xd5, 0x86, 0xf4,
	0x40, 0xa9, 0xcc, 0x7a, 0x77, 0x9a, 0x6e, 0xb5, 0xde, 0x99, 0xcc, 0x9b, 0xb5, 0x14, 0xb8, 0xc0,
	0x85, 0x1b, 0x42, 0xe2, 0xc4, 0x15, 0xc4, 0x89, 0x6f, 0xc0, 0xb7, 0x43, 0x33, 0xbb, 0xeb, 0x78,
	0xd7, 0x76, 0xd8, 0x75, 0x82, 0xc4, 0x6d, 0xe7, 0xcd, 0xbc, 0xdf, 0x7b, 0xf3, 0xfe, 0xcd, 0xcf,
	0x86, 0xfb, 0x2e, 0xf3, 0x68, 0xeb, 0x6d, 0x84, 0xd2, 0x0f, 0x5b, 0xb2, 0xbf, 0x46, 0xfb, 0x34,
	0x94, 0xdd, 0x08, 0xd7, 0x5c, 0x16, 0x4a, 0xc1, 0x02, 0x1e, 0x38, 0x21, 0x5d, 0x13, 0xdc, 0x5d,
	0x43, 0x2a, 0xfa, 0xbe, 0x4b, 0xb1, 0xc5, 0x05, 0x93, 0x8c, 0xdc, 0xcd, 0x2a, 0xb6, 0x52, 0xc5,
	0xd6, 0xb0, 0x62, 0x73, 0xb3, 0x30, 0xbc, 0xde, 0xe9, 0xa0, 0x14, 0xd4, 0xe9, 0x25, 0x36, 0xac,
	0x05, 0x98, 0x3f, 0xf4, 0x51, 0x1e, 0x25, 0x96, 0x6d, 0x7a, 0x6a, 0xbd, 0x82, 0x46, 0x56, 0x84,
	0x9c, 0x1c, 0x40, 0x2d, 0x75, 0xce, 0x34, 0x56, 0x67, 0xee, 0xcd, 0xad, 0x7f, 0xd4, 0x2a, 0xe2,
	0x5d, 0x2b, 0x41, 0xb1, 0x07, 0xea, 0xd6, 0x1d, 0xb8, 0xd1, 0xa6, 0x29, 0xba, 0x4d, 0x4f, 0xc9,
	0x4d, 0xa8, 0xf8, 0x9e, 0x69, 0xac, 0x1a, 0xf7, 0xea, 0x76, 0xc5, 0xf7, 0xac, 0x97, 0xd0, 0xd8,
	0x11, 0xd4, 0x91, 0x74, 0xe8, 0x4c, 0x1b, 0xaa, 0x09, 0x80, 0x3e, 0x58, 0xda, 0x7c, 0xaa, 0x6d,
	0x7d, 0x03, 0x0b, 0x39, 0x70, 0xe4, 0x57, 0x87, 0xfe, 0x12, 0x1a, 0xc7, 0xdc, 0xfb, 0xef, 0x5c,
	0xcf, 0x81, 0x5f, 0xa5, 0xeb, 0x7f, 0x57, 0xa0, 0x9a, 0x08, 0xf3, 0x19, 0x21, 0x04, 0x66, 0x43,
	0xa7, 0x47, 0xcd, 0x8a, 0x96, 0xe8, 0x6f, 0xd2, 0x82, 0xc5, 0x44, 0xb5, 0xe3, 0x3a, 0xd2, 0x09,
	0xd8, 0x49, 0x27, 0x12, 0x81, 0x39, 0xa3, 0x8f, 0x2c, 0x24, 0x5b, 0x3b, 0xf1, 0xce, 0xb1, 0x08,
	0xc8, 0x2a, 0xcc, 0x79, 0x14, 0x5d, 0xe1, 0x73, 0xe9, 0xb3, 0xd0, 0x9c, 0xd5, 0xe7, 0x86, 0x45,
	0xe4, 0x19, 0xd4, 0x1c, 0xd7, 0x65, 0x51, 0x28, 0xd1, 0xbc, 0x56, 0xa6, 0xc6, 0xb6, 0x62, 0xad,
	0xed, 0x8a, 0x69, 0xd8, 0x03, 0x08, 0xb2, 0x02, 0x10, 0x78, 0x0e, 0xef, 0x9c, 0x08, 0x16, 0x71,
	0xf3, 0xba, 0xb6, 0x57, 0x57, 0x92, 0xb6, 0x12, 0x90, 0xa7, 0x50, 0xf7, 0x9d, 0x5e, 0x47, 0xb0,
	0x80, 0xa2, 0x59, 0x2d, 0x63, 0xee, 0x60, 0xeb, 0x99, 0xcd, 0x02, 0x6a, 0xd7, 0x7c, 0xa7, 0xa7,
	0x3e, 0xd0, 0xf2, 0xa0, 0x9a, 0xf8, 0x30, 0x12, 0xba, 0x5b, 0x70, 0x2d, 0x70, 0xba, 0x34, 0x48,
	0x62, 0x17, 0x2f, 0xc8, 0x06, 0x2c, 0xb9, 0x01, 0x8b, 0xbc, 0xd7, 0x4c, 0xf4, 0x1c, 0x75, 0xf9,
	0x0e, 0x4a, 0x47, 0x46, 0x98, 0x84, 0xef, 0x56, 0x76, 0xf3, 0x48, 0xef, 0x59, 0x26, 0xdc, 0xb6,
	0xe9, 0x69, 0x44, 0x51, 0x32, 0x71, 0xb8, 0xbb, 0xf5, 0x5c, 0xdf, 0x43, 0x77, 0xec, 0xa7, 0xf0,
	0xee, 0xd8, 0x1d, 0xe4, 0xe4, 0x0e, 0xcc, 0x9d, 0x47, 0x21, 0xee, 0xdd, 0xba, 0x0d, 0x83, 0x30,
	0xa0, 0xf5, 0x10, 0x4c, 0x9b, 0x22, 0x0b, 0xfa, 0x74, 0xa0, 0x79, 0x8c, 0x54, 0x28, 0xdc, 0x5c,
	0x08, 0x8d, 0x5c, 0x08, 0x2d, 0x06, 0xcb, 0x13, 0x54, 0x91, 0x13, 0x1b, 0xde, 0xd1, 0xba, 0x34,
	0x94, 0xc2, 0x1f, 0x4c, 0x8d, 0xb5, 0x62, 0x21, 0x56, 0x78, 0x7b, 0xa1, 0x14, 0x67, 0xb6, 0xf6,
	0x7e, 0x2f, 0xc6, 0xb0, 0x1e, 0x43, 0x7d, 0xb0, 0xa3, 0x6e, 0xe6, 0xb2, 0x5e, 0x8f, 0x85, 0x1d,
	0x5d, 0x9b, 0xb1, 0x77, 0x10, 0x8b, 0xbe, 0x54, 0x15, 0xda, 0x80, 0x99, 0xc8, 0xf7, 0x92, 0xc0,
	0xab, 0x4f, 0x6b, 0x13, 0xde, 0x6b, 0x53, 0xb9, 0x15, 0xc9, 0x37, 0x4c, 0xf8, 0xdf, 0x51, 0x6f,
	0xdf, 0xa7, 0x81, 0xd7, 0x16, 0x4e, 0x28, 0xd3, 0xeb, 0xa6, 0x25, 0x3d, 0xc8, 0x61, 0x3d, 0x91,
	0x1c, 0x78, 0xd6, 0x8f, 0x15, 0x78, 0x7f, 0xb2, 0x3a, 0x72, 0x72, 0x0a, 0x0b, 0x18, 0x75, 0x55,
	0x41, 0x77, 0xa9, 0xe8, 0x9c, 0xe8, 0x8d, 0xe4, 0xde, 0xbb, 0x05, 0x2b, 0x39, 0x8b, 0x7d, 0x34,
	0x40, 0xd3, 0x56, 0xec, 0x06, 0x66, 0x05, 0x48, 0x42, 0x68, 0xf0, 0xa8, 0x1b, 0xf8, 0xf8, 0xe6,
	0xdc, 0x62, 0x45, 0x5b, 0xdc, 0x99, 0xca, 0xe2, 0xf3, 0x14, 0x2c, 0x36, 0x38, 0xcf, 0x33, 0x6b,
	0xb4, 0xfe, 0x32, 0x60, 0xe5, 0x42, 0x15, 0xf2, 0x05, 0xd4, 0xd2, 0xbe, 0x2a, 0x37, 0x91, 0xd2,
	0xb6, 0xaa, 0x26, 0x6d, 0xa5, 0xd2, 0x11, 0xbf, 0x58, 0xf2, 0x8c, 0xa7, 0xb3, 0xa7, 0xae, 0x25,
	0x5f, 0x9d, 0x71, 0xaa, 0x06, 0x0a, 0x0d, 0xfb, 0xbe, 0x60, 0x61, 0x8f, 0x86, 0x32, 0xe9, 0x9c,
	0x61, 0x91, 0x75, 0x17, 0x1a, 0xbb, 0x34, 0xa0, 0x92, 0xa6, 0xd0, 0xf4, 0x54, 0x15, 0x85, 0x23,
	0xc2, 0x24, 0xb9, 0xea, 0xd3, 0x5a, 0x84, 0x85, 0xdc, 0x29, 0xe4, 0xd6, 0x23, 0x9d, 0xea, 0xf4,
	0x09, 0xdc, 0x67, 0x62, 0x4f, 0xd9, 0x3d, 0xd2, 0x4f, 0x67, 0x52, 0x2a, 0x43, 0xbe, 0x19, 0x39,
	0xdf, 0xac, 0xb7, 0xb0, 0x72, 0x81, 0xfa, 0xd5, 0xbe, 0xa7, 0x27, 0xba, 0xa8, 0x77, 0xd4, 0xc4,
	0xd8, 0x4f, 0x27, 0xc6, 0x0b, 0x2a, 0xd0, 0x67, 0xa1, 0xf2, 0xf4, 0xca, 0xf2, 0x61, 0x3d, 0xd0,
	0x31, 0x99, 0x60, 0x08, 0x39, 0x31, 0xa1, 0xda, 0x8f, 0x97, 0x49, 0x40, 0xd2, 0xa5, 0xf5, 0x7d,
	0xfa, 0xa2, 0x0f, 0x25, 0xe2, 0xe2, 0x66, 0xcb, 0xb8, 0x5d, 0xb9, 0x94, 0xdb, 0xaf, 0xd2, 0x17,
	0x7f, 0x28, 0xbf, 0x57, 0x08, 0xff, 0x04, 0x96, 0xe2, 0x57, 0x39, 0xd9, 0x39, 0x54, 0x03, 0x7e,
	0x6c, 0xa5, 0x8d, 0x7f, 0x0b, 0xac, 0xcf, 0xe1, 0xf6, 0x38, 0x00, 0xe4, 0x85, 0x11, 0x3e, 0x04,
	0xf2, 0xc2, 0x09, 0x7c, 0xcf, 0xf9, 0x97, 0x4a, 0x7f, 0x0a, 0x8b, 0x23, 0xe7, 0x90, 0x93, 0x65,
	0xa8, 0xf9, 0xd8, 0xe9, 0xab, 0x1d, 0x7d, 0xba, 0x66, 0x57, 0x7d, 0xd4, 0x07, 0x55, 0x4a, 0x7b,
	0x14, 0xd1, 0x39, 0x49, 0xfb, 0x2f, 0x5d, 0x5a, 0x7d, 0xa8, 0x26, 0x18, 0x45, 0xdd, 0x9c, 0xea,
	0xd1, 0x4b, 0xde, 0xd3, 0xd9, 0x01, 0x39, 0xfc, 0xb9, 0x02, 0x1f, 0x5c, 0x3c, 0x25, 0xff, 0x47,
	0x13, 0x88, 0x7c, 0x0b, 0x0d, 0x67, 0xe0, 0x6c, 0xe7, 0xb5, 0xf2, 0x56, 0xdf, 0x65, 0x6e, 0xfd,
	0xe3, 0xa9, 0xc6, 0xb3, 0x3d, 0xef, 0x64, 0x05, 0xeb, 0x7f, 0xdc, 0x84, 0x5a, 0x3a, 0x67, 0x48,
	0x04, 0xb3, 0x8a, 0xb9, 0x93, 0x82, 0xe0, 0x39, 0xe2, 0xdf, 0xfc, 0x64, 0x1a, 0x35, 0xe4, 0xc4,
	0x87, 0x99, 0x36, 0x95, 0x64, 0xa3, 0x98, 0x7a, 0x86, 0xfc, 0x37, 0xcb, 0x8d, 0x3d, 0x72, 0x06,
	0xd7, 0xe3, 0x66, 0x26, 0x05, 0x9d, 0xcd, 0xff, 0x92, 0x68, 0xde, 0x9f, 0x4a, 0x0f, 0xb9, 0x32,
	0x1d, 0xf7, 0x69, 0x51, 0xd3, 0xf9, 0x5f, 0x02, 0x45, 0x4d, 0x8f, 0x92, 0xfc, 0xdf, 0x0d, 0x30,
	0x27, 0x31, 0x0f, 0xb2, 0x55, 0x38, 0xec, 0x93, 0x88, 0x4f, 0x73, 0xfb, 0xb2, 0x10, 0xc8, 0xc9,
	0xaf, 0x06, 0x2c, 0x8e, 0x21, 0xa1, 0x64, 0xb3, 0x18, 0xf6, 0x78, 0x66, 0xdb, 0x7c, 0x74, 0x09,
	0x6d, 0xe4, 0xe4, 0x37, 0x03, 0x96, 0xc6, 0x52, 0x54, 0xf2, 0xb8, 0x28, 0xf0, 0x78, 0x6a, 0xdc,
	0x7c, 0x72, 0x29, 0x7d, 0xe4, 0xe4, 0x07, 0x03, 0x6e, 0x64, 0x78, 0x47, 0xd1, 0xb2, 0xca, 0x53,
	0x9a, 0xa2, 0x65, 0x35, 0x42, 0x72, 0xc8, 0x9f, 0x06, 0x2c, 0x4f, 0xa4, 0x29, 0x64, 0xbb, 0x6c,
	0x3b, 0x8f, 0xd2, 0xa4, 0xe6, 0xce, 0xa5, 0x31, 0xce, 0xab, 0x7f, 0x2c, 0xf1, 0x28, 0x51, 0xfd,
	0x93, 0x18, 0x52, 0x89, 0xea, 0x9f, 0xcc, 0x7d, 0x54, 0x36, 0x33, 0x2c, 0xa3, 0xdc, 0x7c, 0x2a,
	0x9f, 0xcd, 0x51, 0x4a, 0xf3, 0x8b, 0x01, 0x64, 0x94, 0x48, 0x90, 0xcf, 0xca, 0x0c, 0x9d, 0x1c,
	0x87, 0x69, 0x6e, 0x4e, 0xaf, 0x8c, 0x9c, 0xfc, 0x64, 0xc0, 0x7c, 0x8e, 0x70, 0x90, 0x07, 0xc5,
	0x10, 0x47, 0xf9, 0x4c, 0xf3, 0xe1, 0x94, 0x9a, 0xc8, 0xb7, 0xaf, 0x7d, 0x3d, 0x23, 0xb8, 0xdb,
	0xbd, 0xae, 0xff, 0xf2, 0xda, 0xf8, 0x27, 0x00, 0x00, 0xff, 0xff, 0x37, 0xf4, 0xc4, 0x6a, 0x91,
	0x13, 0x00, 0x00,
}
