// Code generated by protoc-gen-go. DO NOT EDIT.
// source: code.justin.tv/eventbus/controlplane/rpc/targets.proto

package rpc

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// The dashboard can use this information to report the state of the SQS target back to the user.
type SQSStatus int32

const (
	SQSStatus_UNKNOWN        SQSStatus = 0
	SQSStatus_PENDING_CREATE SQSStatus = 1
	SQSStatus_PENDING_DELETE SQSStatus = 2
	SQSStatus_CREATED        SQSStatus = 3
	SQSStatus_DELETED        SQSStatus = 4
	SQSStatus_ERROR          SQSStatus = 5
)

var SQSStatus_name = map[int32]string{
	0: "UNKNOWN",
	1: "PENDING_CREATE",
	2: "PENDING_DELETE",
	3: "CREATED",
	4: "DELETED",
	5: "ERROR",
}
var SQSStatus_value = map[string]int32{
	"UNKNOWN":        0,
	"PENDING_CREATE": 1,
	"PENDING_DELETE": 2,
	"CREATED":        3,
	"DELETED":        4,
	"ERROR":          5,
}

func (x SQSStatus) String() string {
	return proto.EnumName(SQSStatus_name, int32(x))
}
func (SQSStatus) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_targets_176ab722f7ed7df8, []int{0}
}

type TargetType int32

const (
	TargetType_TARGET_TYPE_UNKNOWN TargetType = 0
	TargetType_TARGET_TYPE_SQS     TargetType = 1
	TargetType_TARGET_TYPE_HTTP    TargetType = 2
	TargetType_TARGET_TYPE_LAMBDA  TargetType = 3
)

var TargetType_name = map[int32]string{
	0: "TARGET_TYPE_UNKNOWN",
	1: "TARGET_TYPE_SQS",
	2: "TARGET_TYPE_HTTP",
	3: "TARGET_TYPE_LAMBDA",
}
var TargetType_value = map[string]int32{
	"TARGET_TYPE_UNKNOWN": 0,
	"TARGET_TYPE_SQS":     1,
	"TARGET_TYPE_HTTP":    2,
	"TARGET_TYPE_LAMBDA":  3,
}

func (x TargetType) String() string {
	return proto.EnumName(TargetType_name, int32(x))
}
func (TargetType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_targets_176ab722f7ed7df8, []int{1}
}

type Target struct {
	// The ID of the service which this target belongs to
	Id        string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	ServiceId string `protobuf:"bytes,2,opt,name=service_id,json=serviceId,proto3" json:"service_id,omitempty"`
	// Only one type of target can be created.
	// This encapsulates target-specific details and also effectively declares
	// what kind of target this is at the same time.
	//
	// Types that are valid to be assigned to Details:
	//	*Target_Sqs
	//	*Target_Http
	//	*Target_Lambda
	Details              isTarget_Details `protobuf_oneof:"details"`
	Name                 string           `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	AwsAccountId         string           `protobuf:"bytes,7,opt,name=aws_account_id,json=awsAccountId,proto3" json:"aws_account_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Target) Reset()         { *m = Target{} }
func (m *Target) String() string { return proto.CompactTextString(m) }
func (*Target) ProtoMessage()    {}
func (*Target) Descriptor() ([]byte, []int) {
	return fileDescriptor_targets_176ab722f7ed7df8, []int{0}
}
func (m *Target) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Target.Unmarshal(m, b)
}
func (m *Target) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Target.Marshal(b, m, deterministic)
}
func (dst *Target) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Target.Merge(dst, src)
}
func (m *Target) XXX_Size() int {
	return xxx_messageInfo_Target.Size(m)
}
func (m *Target) XXX_DiscardUnknown() {
	xxx_messageInfo_Target.DiscardUnknown(m)
}

var xxx_messageInfo_Target proto.InternalMessageInfo

func (m *Target) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Target) GetServiceId() string {
	if m != nil {
		return m.ServiceId
	}
	return ""
}

type isTarget_Details interface {
	isTarget_Details()
}

type Target_Sqs struct {
	Sqs *SQSDetails `protobuf:"bytes,3,opt,name=sqs,proto3,oneof"`
}

type Target_Http struct {
	Http *HTTPDetails `protobuf:"bytes,4,opt,name=http,proto3,oneof"`
}

type Target_Lambda struct {
	Lambda *LambdaDetails `protobuf:"bytes,5,opt,name=lambda,proto3,oneof"`
}

func (*Target_Sqs) isTarget_Details() {}

func (*Target_Http) isTarget_Details() {}

func (*Target_Lambda) isTarget_Details() {}

func (m *Target) GetDetails() isTarget_Details {
	if m != nil {
		return m.Details
	}
	return nil
}

func (m *Target) GetSqs() *SQSDetails {
	if x, ok := m.GetDetails().(*Target_Sqs); ok {
		return x.Sqs
	}
	return nil
}

func (m *Target) GetHttp() *HTTPDetails {
	if x, ok := m.GetDetails().(*Target_Http); ok {
		return x.Http
	}
	return nil
}

func (m *Target) GetLambda() *LambdaDetails {
	if x, ok := m.GetDetails().(*Target_Lambda); ok {
		return x.Lambda
	}
	return nil
}

func (m *Target) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Target) GetAwsAccountId() string {
	if m != nil {
		return m.AwsAccountId
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Target) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Target_OneofMarshaler, _Target_OneofUnmarshaler, _Target_OneofSizer, []interface{}{
		(*Target_Sqs)(nil),
		(*Target_Http)(nil),
		(*Target_Lambda)(nil),
	}
}

func _Target_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Target)
	// details
	switch x := m.Details.(type) {
	case *Target_Sqs:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Sqs); err != nil {
			return err
		}
	case *Target_Http:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Http); err != nil {
			return err
		}
	case *Target_Lambda:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Lambda); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Target.Details has unexpected type %T", x)
	}
	return nil
}

func _Target_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Target)
	switch tag {
	case 3: // details.sqs
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SQSDetails)
		err := b.DecodeMessage(msg)
		m.Details = &Target_Sqs{msg}
		return true, err
	case 4: // details.http
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(HTTPDetails)
		err := b.DecodeMessage(msg)
		m.Details = &Target_Http{msg}
		return true, err
	case 5: // details.lambda
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(LambdaDetails)
		err := b.DecodeMessage(msg)
		m.Details = &Target_Lambda{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Target_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Target)
	// details
	switch x := m.Details.(type) {
	case *Target_Sqs:
		s := proto.Size(x.Sqs)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Target_Http:
		s := proto.Size(x.Http)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Target_Lambda:
		s := proto.Size(x.Lambda)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type CreateTargetReq struct {
	ServiceId string     `protobuf:"bytes,1,opt,name=service_id,json=serviceId,proto3" json:"service_id,omitempty"`
	Name      string     `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	Type      TargetType `protobuf:"varint,3,opt,name=type,proto3,enum=code.justin.tv.eventbus.controlplane.TargetType" json:"type,omitempty"`
	// string sqs_assume_role_arn = 4; // only needed for SQS type
	HttpEndpoint      string `protobuf:"bytes,5,opt,name=http_endpoint,json=httpEndpoint,proto3" json:"http_endpoint,omitempty"`
	LambdaFunctionArn string `protobuf:"bytes,6,opt,name=lambda_function_arn,json=lambdaFunctionArn,proto3" json:"lambda_function_arn,omitempty"`
	// Types that are valid to be assigned to Details:
	//	*CreateTargetReq_Sqs
	Details              isCreateTargetReq_Details `protobuf_oneof:"details"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *CreateTargetReq) Reset()         { *m = CreateTargetReq{} }
func (m *CreateTargetReq) String() string { return proto.CompactTextString(m) }
func (*CreateTargetReq) ProtoMessage()    {}
func (*CreateTargetReq) Descriptor() ([]byte, []int) {
	return fileDescriptor_targets_176ab722f7ed7df8, []int{1}
}
func (m *CreateTargetReq) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateTargetReq.Unmarshal(m, b)
}
func (m *CreateTargetReq) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateTargetReq.Marshal(b, m, deterministic)
}
func (dst *CreateTargetReq) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateTargetReq.Merge(dst, src)
}
func (m *CreateTargetReq) XXX_Size() int {
	return xxx_messageInfo_CreateTargetReq.Size(m)
}
func (m *CreateTargetReq) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateTargetReq.DiscardUnknown(m)
}

var xxx_messageInfo_CreateTargetReq proto.InternalMessageInfo

func (m *CreateTargetReq) GetServiceId() string {
	if m != nil {
		return m.ServiceId
	}
	return ""
}

func (m *CreateTargetReq) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateTargetReq) GetType() TargetType {
	if m != nil {
		return m.Type
	}
	return TargetType_TARGET_TYPE_UNKNOWN
}

func (m *CreateTargetReq) GetHttpEndpoint() string {
	if m != nil {
		return m.HttpEndpoint
	}
	return ""
}

func (m *CreateTargetReq) GetLambdaFunctionArn() string {
	if m != nil {
		return m.LambdaFunctionArn
	}
	return ""
}

type isCreateTargetReq_Details interface {
	isCreateTargetReq_Details()
}

type CreateTargetReq_Sqs struct {
	Sqs *SQSDetails `protobuf:"bytes,9,opt,name=sqs,proto3,oneof"`
}

func (*CreateTargetReq_Sqs) isCreateTargetReq_Details() {}

func (m *CreateTargetReq) GetDetails() isCreateTargetReq_Details {
	if m != nil {
		return m.Details
	}
	return nil
}

func (m *CreateTargetReq) GetSqs() *SQSDetails {
	if x, ok := m.GetDetails().(*CreateTargetReq_Sqs); ok {
		return x.Sqs
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*CreateTargetReq) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _CreateTargetReq_OneofMarshaler, _CreateTargetReq_OneofUnmarshaler, _CreateTargetReq_OneofSizer, []interface{}{
		(*CreateTargetReq_Sqs)(nil),
	}
}

func _CreateTargetReq_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*CreateTargetReq)
	// details
	switch x := m.Details.(type) {
	case *CreateTargetReq_Sqs:
		b.EncodeVarint(9<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Sqs); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("CreateTargetReq.Details has unexpected type %T", x)
	}
	return nil
}

func _CreateTargetReq_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*CreateTargetReq)
	switch tag {
	case 9: // details.sqs
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SQSDetails)
		err := b.DecodeMessage(msg)
		m.Details = &CreateTargetReq_Sqs{msg}
		return true, err
	default:
		return false, nil
	}
}

func _CreateTargetReq_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*CreateTargetReq)
	// details
	switch x := m.Details.(type) {
	case *CreateTargetReq_Sqs:
		s := proto.Size(x.Sqs)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type CreateTargetResp struct {
	Target               *Target  `protobuf:"bytes,1,opt,name=target,proto3" json:"target,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateTargetResp) Reset()         { *m = CreateTargetResp{} }
func (m *CreateTargetResp) String() string { return proto.CompactTextString(m) }
func (*CreateTargetResp) ProtoMessage()    {}
func (*CreateTargetResp) Descriptor() ([]byte, []int) {
	return fileDescriptor_targets_176ab722f7ed7df8, []int{2}
}
func (m *CreateTargetResp) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateTargetResp.Unmarshal(m, b)
}
func (m *CreateTargetResp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateTargetResp.Marshal(b, m, deterministic)
}
func (dst *CreateTargetResp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateTargetResp.Merge(dst, src)
}
func (m *CreateTargetResp) XXX_Size() int {
	return xxx_messageInfo_CreateTargetResp.Size(m)
}
func (m *CreateTargetResp) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateTargetResp.DiscardUnknown(m)
}

var xxx_messageInfo_CreateTargetResp proto.InternalMessageInfo

func (m *CreateTargetResp) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

type DeleteTargetReq struct {
	SubscriptionTargetId string   `protobuf:"bytes,1,opt,name=subscription_target_id,json=subscriptionTargetId,proto3" json:"subscription_target_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteTargetReq) Reset()         { *m = DeleteTargetReq{} }
func (m *DeleteTargetReq) String() string { return proto.CompactTextString(m) }
func (*DeleteTargetReq) ProtoMessage()    {}
func (*DeleteTargetReq) Descriptor() ([]byte, []int) {
	return fileDescriptor_targets_176ab722f7ed7df8, []int{3}
}
func (m *DeleteTargetReq) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteTargetReq.Unmarshal(m, b)
}
func (m *DeleteTargetReq) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteTargetReq.Marshal(b, m, deterministic)
}
func (dst *DeleteTargetReq) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteTargetReq.Merge(dst, src)
}
func (m *DeleteTargetReq) XXX_Size() int {
	return xxx_messageInfo_DeleteTargetReq.Size(m)
}
func (m *DeleteTargetReq) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteTargetReq.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteTargetReq proto.InternalMessageInfo

func (m *DeleteTargetReq) GetSubscriptionTargetId() string {
	if m != nil {
		return m.SubscriptionTargetId
	}
	return ""
}

type DeleteTargetResp struct {
	SubscriptionTargetId string   `protobuf:"bytes,1,opt,name=subscription_target_id,json=subscriptionTargetId,proto3" json:"subscription_target_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteTargetResp) Reset()         { *m = DeleteTargetResp{} }
func (m *DeleteTargetResp) String() string { return proto.CompactTextString(m) }
func (*DeleteTargetResp) ProtoMessage()    {}
func (*DeleteTargetResp) Descriptor() ([]byte, []int) {
	return fileDescriptor_targets_176ab722f7ed7df8, []int{4}
}
func (m *DeleteTargetResp) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteTargetResp.Unmarshal(m, b)
}
func (m *DeleteTargetResp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteTargetResp.Marshal(b, m, deterministic)
}
func (dst *DeleteTargetResp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteTargetResp.Merge(dst, src)
}
func (m *DeleteTargetResp) XXX_Size() int {
	return xxx_messageInfo_DeleteTargetResp.Size(m)
}
func (m *DeleteTargetResp) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteTargetResp.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteTargetResp proto.InternalMessageInfo

func (m *DeleteTargetResp) GetSubscriptionTargetId() string {
	if m != nil {
		return m.SubscriptionTargetId
	}
	return ""
}

type GetTargetsForServiceReq struct {
	// TODO: someday this could have pagination support,
	// or filtering on type, etc
	ServiceId            string   `protobuf:"bytes,1,opt,name=service_id,json=serviceId,proto3" json:"service_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetTargetsForServiceReq) Reset()         { *m = GetTargetsForServiceReq{} }
func (m *GetTargetsForServiceReq) String() string { return proto.CompactTextString(m) }
func (*GetTargetsForServiceReq) ProtoMessage()    {}
func (*GetTargetsForServiceReq) Descriptor() ([]byte, []int) {
	return fileDescriptor_targets_176ab722f7ed7df8, []int{5}
}
func (m *GetTargetsForServiceReq) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetTargetsForServiceReq.Unmarshal(m, b)
}
func (m *GetTargetsForServiceReq) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetTargetsForServiceReq.Marshal(b, m, deterministic)
}
func (dst *GetTargetsForServiceReq) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetTargetsForServiceReq.Merge(dst, src)
}
func (m *GetTargetsForServiceReq) XXX_Size() int {
	return xxx_messageInfo_GetTargetsForServiceReq.Size(m)
}
func (m *GetTargetsForServiceReq) XXX_DiscardUnknown() {
	xxx_messageInfo_GetTargetsForServiceReq.DiscardUnknown(m)
}

var xxx_messageInfo_GetTargetsForServiceReq proto.InternalMessageInfo

func (m *GetTargetsForServiceReq) GetServiceId() string {
	if m != nil {
		return m.ServiceId
	}
	return ""
}

type GetTargetsForServiceResp struct {
	// TODO: someday this could have pagination support,
	// or filtering on type, etc
	ServiceId            string    `protobuf:"bytes,1,opt,name=service_id,json=serviceId,proto3" json:"service_id,omitempty"`
	Targets              []*Target `protobuf:"bytes,2,rep,name=targets,proto3" json:"targets,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *GetTargetsForServiceResp) Reset()         { *m = GetTargetsForServiceResp{} }
func (m *GetTargetsForServiceResp) String() string { return proto.CompactTextString(m) }
func (*GetTargetsForServiceResp) ProtoMessage()    {}
func (*GetTargetsForServiceResp) Descriptor() ([]byte, []int) {
	return fileDescriptor_targets_176ab722f7ed7df8, []int{6}
}
func (m *GetTargetsForServiceResp) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetTargetsForServiceResp.Unmarshal(m, b)
}
func (m *GetTargetsForServiceResp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetTargetsForServiceResp.Marshal(b, m, deterministic)
}
func (dst *GetTargetsForServiceResp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetTargetsForServiceResp.Merge(dst, src)
}
func (m *GetTargetsForServiceResp) XXX_Size() int {
	return xxx_messageInfo_GetTargetsForServiceResp.Size(m)
}
func (m *GetTargetsForServiceResp) XXX_DiscardUnknown() {
	xxx_messageInfo_GetTargetsForServiceResp.DiscardUnknown(m)
}

var xxx_messageInfo_GetTargetsForServiceResp proto.InternalMessageInfo

func (m *GetTargetsForServiceResp) GetServiceId() string {
	if m != nil {
		return m.ServiceId
	}
	return ""
}

func (m *GetTargetsForServiceResp) GetTargets() []*Target {
	if m != nil {
		return m.Targets
	}
	return nil
}

type ValidateTargetReq struct {
	SqsQueueUrl          string   `protobuf:"bytes,1,opt,name=sqs_queue_url,json=sqsQueueUrl,proto3" json:"sqs_queue_url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ValidateTargetReq) Reset()         { *m = ValidateTargetReq{} }
func (m *ValidateTargetReq) String() string { return proto.CompactTextString(m) }
func (*ValidateTargetReq) ProtoMessage()    {}
func (*ValidateTargetReq) Descriptor() ([]byte, []int) {
	return fileDescriptor_targets_176ab722f7ed7df8, []int{7}
}
func (m *ValidateTargetReq) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ValidateTargetReq.Unmarshal(m, b)
}
func (m *ValidateTargetReq) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ValidateTargetReq.Marshal(b, m, deterministic)
}
func (dst *ValidateTargetReq) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ValidateTargetReq.Merge(dst, src)
}
func (m *ValidateTargetReq) XXX_Size() int {
	return xxx_messageInfo_ValidateTargetReq.Size(m)
}
func (m *ValidateTargetReq) XXX_DiscardUnknown() {
	xxx_messageInfo_ValidateTargetReq.DiscardUnknown(m)
}

var xxx_messageInfo_ValidateTargetReq proto.InternalMessageInfo

func (m *ValidateTargetReq) GetSqsQueueUrl() string {
	if m != nil {
		return m.SqsQueueUrl
	}
	return ""
}

type ValidateTargetResp struct {
	IsValid              bool     `protobuf:"varint,1,opt,name=isValid,proto3" json:"isValid,omitempty"`
	Message              string   `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ValidateTargetResp) Reset()         { *m = ValidateTargetResp{} }
func (m *ValidateTargetResp) String() string { return proto.CompactTextString(m) }
func (*ValidateTargetResp) ProtoMessage()    {}
func (*ValidateTargetResp) Descriptor() ([]byte, []int) {
	return fileDescriptor_targets_176ab722f7ed7df8, []int{8}
}
func (m *ValidateTargetResp) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ValidateTargetResp.Unmarshal(m, b)
}
func (m *ValidateTargetResp) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ValidateTargetResp.Marshal(b, m, deterministic)
}
func (dst *ValidateTargetResp) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ValidateTargetResp.Merge(dst, src)
}
func (m *ValidateTargetResp) XXX_Size() int {
	return xxx_messageInfo_ValidateTargetResp.Size(m)
}
func (m *ValidateTargetResp) XXX_DiscardUnknown() {
	xxx_messageInfo_ValidateTargetResp.DiscardUnknown(m)
}

var xxx_messageInfo_ValidateTargetResp proto.InternalMessageInfo

func (m *ValidateTargetResp) GetIsValid() bool {
	if m != nil {
		return m.IsValid
	}
	return false
}

func (m *ValidateTargetResp) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

type SQSDetails struct {
	// The cross-account role to assume to create this SQS queue, and
	// potentially do other things like fetch metrics
	AssumeRoleArn string `protobuf:"bytes,1,opt,name=assume_role_arn,json=assumeRoleArn,proto3" json:"assume_role_arn,omitempty"`
	// The SQS Queue ARN for this target. The controlplane convergence process
	// will use the assume_role_arn to create this queue. When this value is empty,
	// it is assumed that the SQS queue has not yet been created.
	QueueArn      string    `protobuf:"bytes,2,opt,name=queue_arn,json=queueArn,proto3" json:"queue_arn,omitempty"`
	SqsStatus     SQSStatus `protobuf:"varint,3,opt,name=sqs_status,json=sqsStatus,proto3,enum=code.justin.tv.eventbus.controlplane.SQSStatus" json:"sqs_status,omitempty"`
	StatusMessage string    `protobuf:"bytes,4,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// The SQS Queue URL for this target. This is given to clients as needed.
	QueueUrl string `protobuf:"bytes,5,opt,name=queue_url,json=queueUrl,proto3" json:"queue_url,omitempty"`
	// Dead-letter queue ARN and URL are blank if dead-letter queue is disabled.
	DeadletterQueueArn   string   `protobuf:"bytes,6,opt,name=deadletter_queue_arn,json=deadletterQueueArn,proto3" json:"deadletter_queue_arn,omitempty"`
	DeadletterQueueUrl   string   `protobuf:"bytes,7,opt,name=deadletter_queue_url,json=deadletterQueueUrl,proto3" json:"deadletter_queue_url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SQSDetails) Reset()         { *m = SQSDetails{} }
func (m *SQSDetails) String() string { return proto.CompactTextString(m) }
func (*SQSDetails) ProtoMessage()    {}
func (*SQSDetails) Descriptor() ([]byte, []int) {
	return fileDescriptor_targets_176ab722f7ed7df8, []int{9}
}
func (m *SQSDetails) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SQSDetails.Unmarshal(m, b)
}
func (m *SQSDetails) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SQSDetails.Marshal(b, m, deterministic)
}
func (dst *SQSDetails) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SQSDetails.Merge(dst, src)
}
func (m *SQSDetails) XXX_Size() int {
	return xxx_messageInfo_SQSDetails.Size(m)
}
func (m *SQSDetails) XXX_DiscardUnknown() {
	xxx_messageInfo_SQSDetails.DiscardUnknown(m)
}

var xxx_messageInfo_SQSDetails proto.InternalMessageInfo

func (m *SQSDetails) GetAssumeRoleArn() string {
	if m != nil {
		return m.AssumeRoleArn
	}
	return ""
}

func (m *SQSDetails) GetQueueArn() string {
	if m != nil {
		return m.QueueArn
	}
	return ""
}

func (m *SQSDetails) GetSqsStatus() SQSStatus {
	if m != nil {
		return m.SqsStatus
	}
	return SQSStatus_UNKNOWN
}

func (m *SQSDetails) GetStatusMessage() string {
	if m != nil {
		return m.StatusMessage
	}
	return ""
}

func (m *SQSDetails) GetQueueUrl() string {
	if m != nil {
		return m.QueueUrl
	}
	return ""
}

func (m *SQSDetails) GetDeadletterQueueArn() string {
	if m != nil {
		return m.DeadletterQueueArn
	}
	return ""
}

func (m *SQSDetails) GetDeadletterQueueUrl() string {
	if m != nil {
		return m.DeadletterQueueUrl
	}
	return ""
}

// TODO: not implemented yet
// HTTP endpoints are always created in the PENDING_VALIDATION state.
// This is because SNS will make a request to the endpoint with a special validation
// type of message and the service providing said endpoint is required to contact either
// an API or special confirm URL to confirm the subscription is valid, before any messages
// are delivered.
type HTTPDetails struct {
	// an SNS HTTP Delivery endpoint. Must be fully qualified HTTP URL that resolves
	// and is ready to accept SNS JSON POSTs.
	Endpoint             string   `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HTTPDetails) Reset()         { *m = HTTPDetails{} }
func (m *HTTPDetails) String() string { return proto.CompactTextString(m) }
func (*HTTPDetails) ProtoMessage()    {}
func (*HTTPDetails) Descriptor() ([]byte, []int) {
	return fileDescriptor_targets_176ab722f7ed7df8, []int{10}
}
func (m *HTTPDetails) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HTTPDetails.Unmarshal(m, b)
}
func (m *HTTPDetails) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HTTPDetails.Marshal(b, m, deterministic)
}
func (dst *HTTPDetails) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HTTPDetails.Merge(dst, src)
}
func (m *HTTPDetails) XXX_Size() int {
	return xxx_messageInfo_HTTPDetails.Size(m)
}
func (m *HTTPDetails) XXX_DiscardUnknown() {
	xxx_messageInfo_HTTPDetails.DiscardUnknown(m)
}

var xxx_messageInfo_HTTPDetails proto.InternalMessageInfo

func (m *HTTPDetails) GetEndpoint() string {
	if m != nil {
		return m.Endpoint
	}
	return ""
}

// TODO: not implemented yet
type LambdaDetails struct {
	// The ARN of the Lambda Function that will handle these messages
	FunctionArn          string   `protobuf:"bytes,1,opt,name=function_arn,json=functionArn,proto3" json:"function_arn,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LambdaDetails) Reset()         { *m = LambdaDetails{} }
func (m *LambdaDetails) String() string { return proto.CompactTextString(m) }
func (*LambdaDetails) ProtoMessage()    {}
func (*LambdaDetails) Descriptor() ([]byte, []int) {
	return fileDescriptor_targets_176ab722f7ed7df8, []int{11}
}
func (m *LambdaDetails) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LambdaDetails.Unmarshal(m, b)
}
func (m *LambdaDetails) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LambdaDetails.Marshal(b, m, deterministic)
}
func (dst *LambdaDetails) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LambdaDetails.Merge(dst, src)
}
func (m *LambdaDetails) XXX_Size() int {
	return xxx_messageInfo_LambdaDetails.Size(m)
}
func (m *LambdaDetails) XXX_DiscardUnknown() {
	xxx_messageInfo_LambdaDetails.DiscardUnknown(m)
}

var xxx_messageInfo_LambdaDetails proto.InternalMessageInfo

func (m *LambdaDetails) GetFunctionArn() string {
	if m != nil {
		return m.FunctionArn
	}
	return ""
}

func init() {
	proto.RegisterType((*Target)(nil), "code.justin.tv.eventbus.controlplane.Target")
	proto.RegisterType((*CreateTargetReq)(nil), "code.justin.tv.eventbus.controlplane.CreateTargetReq")
	proto.RegisterType((*CreateTargetResp)(nil), "code.justin.tv.eventbus.controlplane.CreateTargetResp")
	proto.RegisterType((*DeleteTargetReq)(nil), "code.justin.tv.eventbus.controlplane.DeleteTargetReq")
	proto.RegisterType((*DeleteTargetResp)(nil), "code.justin.tv.eventbus.controlplane.DeleteTargetResp")
	proto.RegisterType((*GetTargetsForServiceReq)(nil), "code.justin.tv.eventbus.controlplane.GetTargetsForServiceReq")
	proto.RegisterType((*GetTargetsForServiceResp)(nil), "code.justin.tv.eventbus.controlplane.GetTargetsForServiceResp")
	proto.RegisterType((*ValidateTargetReq)(nil), "code.justin.tv.eventbus.controlplane.ValidateTargetReq")
	proto.RegisterType((*ValidateTargetResp)(nil), "code.justin.tv.eventbus.controlplane.ValidateTargetResp")
	proto.RegisterType((*SQSDetails)(nil), "code.justin.tv.eventbus.controlplane.SQSDetails")
	proto.RegisterType((*HTTPDetails)(nil), "code.justin.tv.eventbus.controlplane.HTTPDetails")
	proto.RegisterType((*LambdaDetails)(nil), "code.justin.tv.eventbus.controlplane.LambdaDetails")
	proto.RegisterEnum("code.justin.tv.eventbus.controlplane.SQSStatus", SQSStatus_name, SQSStatus_value)
	proto.RegisterEnum("code.justin.tv.eventbus.controlplane.TargetType", TargetType_name, TargetType_value)
}

func init() {
	proto.RegisterFile("code.justin.tv/eventbus/controlplane/rpc/targets.proto", fileDescriptor_targets_176ab722f7ed7df8)
}

var fileDescriptor_targets_176ab722f7ed7df8 = []byte{
	// 909 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x56, 0xdd, 0x6e, 0xdb, 0x36,
	0x18, 0xad, 0x65, 0xd9, 0x96, 0x3e, 0x27, 0x8e, 0xca, 0x04, 0xad, 0x90, 0x61, 0x40, 0xa6, 0x75,
	0x43, 0x57, 0x0c, 0x76, 0x97, 0x6e, 0x6d, 0x6f, 0x36, 0xc0, 0xa9, 0x14, 0x27, 0x59, 0xe2, 0x26,
	0xb2, 0xb2, 0xbf, 0x1b, 0x41, 0x91, 0xd8, 0x56, 0x83, 0x22, 0xc9, 0x22, 0x95, 0xa0, 0x17, 0xbb,
	0xd8, 0x2b, 0x0c, 0xd8, 0x0b, 0xed, 0x6e, 0xaf, 0xb0, 0xa7, 0x19, 0x48, 0x4a, 0x91, 0xec, 0xa6,
	0xa8, 0x9a, 0xdc, 0x99, 0xe7, 0xd3, 0x39, 0x1f, 0x79, 0xf8, 0xf1, 0x24, 0xf0, 0xd4, 0x4f, 0x02,
	0x3c, 0xfc, 0x3d, 0x27, 0x34, 0x8c, 0x87, 0xf4, 0x62, 0x84, 0x2f, 0x70, 0x4c, 0xcf, 0x72, 0x32,
	0xf2, 0x93, 0x98, 0x66, 0x49, 0x94, 0x46, 0x5e, 0x8c, 0x47, 0x59, 0xea, 0x8f, 0xa8, 0x97, 0xbd,
	0xc6, 0x94, 0x0c, 0xd3, 0x2c, 0xa1, 0x09, 0x7a, 0xb0, 0xc8, 0x1b, 0x96, 0xbc, 0x61, 0x9d, 0x67,
	0xfc, 0x27, 0x41, 0xd7, 0xe1, 0x3c, 0x34, 0x00, 0x29, 0x0c, 0xf4, 0xd6, 0x56, 0xeb, 0xa1, 0x6a,
	0x4b, 0x61, 0x80, 0x3e, 0x05, 0x20, 0x38, 0xbb, 0x08, 0x7d, 0xec, 0x86, 0x81, 0x2e, 0x71, 0x5c,
	0x2d, 0x90, 0xfd, 0x00, 0x99, 0xd0, 0x26, 0x73, 0xa2, 0xb7, 0xb7, 0x5a, 0x0f, 0xfb, 0xdb, 0x8f,
	0x87, 0x4d, 0xba, 0x0d, 0x67, 0x27, 0x33, 0x13, 0x53, 0x2f, 0x8c, 0xc8, 0xde, 0x1d, 0x9b, 0xd1,
	0xd1, 0x04, 0xe4, 0x37, 0x94, 0xa6, 0xba, 0xcc, 0x65, 0xbe, 0x69, 0x26, 0xb3, 0xe7, 0x38, 0xc7,
	0x95, 0x0e, 0x17, 0x40, 0x47, 0xd0, 0x8d, 0xbc, 0xf3, 0xb3, 0xc0, 0xd3, 0x3b, 0x5c, 0xea, 0x49,
	0x33, 0xa9, 0x43, 0xce, 0xa9, 0xc4, 0x0a, 0x11, 0x84, 0x40, 0x8e, 0xbd, 0x73, 0xac, 0x77, 0xf9,
	0xb1, 0xf9, 0x6f, 0xf4, 0x00, 0x06, 0xde, 0x25, 0x71, 0x3d, 0xdf, 0x4f, 0xf2, 0x98, 0x32, 0x53,
	0x7a, 0xbc, 0xba, 0xe2, 0x5d, 0x92, 0xb1, 0x00, 0xf7, 0x83, 0x1d, 0x15, 0x7a, 0x81, 0x90, 0x33,
	0xfe, 0x91, 0x60, 0xed, 0x45, 0x86, 0x3d, 0x8a, 0x85, 0xc5, 0x36, 0x9e, 0x2f, 0xb9, 0xda, 0x5a,
	0x76, 0xb5, 0xec, 0x2b, 0xd5, 0xfa, 0x9a, 0x20, 0xd3, 0xb7, 0x29, 0xe6, 0x56, 0x0f, 0x9a, 0x5a,
	0x2d, 0x3a, 0x3a, 0x6f, 0x53, 0x6c, 0x73, 0x36, 0xfa, 0x1c, 0x56, 0x99, 0x51, 0x2e, 0x8e, 0x83,
	0x34, 0x09, 0x63, 0xca, 0x7d, 0x52, 0xed, 0x15, 0x06, 0x5a, 0x05, 0x86, 0x86, 0xb0, 0x2e, 0x0c,
	0x70, 0x5f, 0xe5, 0xb1, 0x4f, 0xc3, 0x24, 0x76, 0xbd, 0x2c, 0x2e, 0x5c, 0xb8, 0x2b, 0x4a, 0xbb,
	0x45, 0x65, 0x9c, 0xc5, 0xe5, 0x10, 0xa8, 0xb7, 0x1a, 0x82, 0x9a, 0x65, 0x07, 0xb2, 0x22, 0x6b,
	0x9d, 0x03, 0x59, 0xe9, 0x69, 0xca, 0x81, 0xac, 0x28, 0x9a, 0x6a, 0xfc, 0x02, 0xda, 0xa2, 0x87,
	0x24, 0x45, 0x26, 0x74, 0xc5, 0xb0, 0x73, 0x03, 0xfb, 0xdb, 0x5f, 0x7f, 0x8c, 0x27, 0x76, 0xc1,
	0x35, 0x26, 0xb0, 0x66, 0xe2, 0x08, 0xd7, 0x6f, 0xe7, 0x5b, 0xb8, 0x47, 0xf2, 0x33, 0xe2, 0x67,
	0x61, 0xca, 0x0f, 0x2f, 0xbe, 0xac, 0x6e, 0x6a, 0xa3, 0x5e, 0x15, 0xb4, 0xfd, 0xc0, 0xd8, 0x03,
	0x6d, 0x51, 0x88, 0xa4, 0x37, 0x54, 0x7a, 0x0e, 0xf7, 0x27, 0x98, 0x8a, 0x25, 0xd9, 0x4d, 0xb2,
	0x99, 0x18, 0x8c, 0x0f, 0x0f, 0x8e, 0xf1, 0x67, 0x0b, 0xf4, 0xeb, 0xa9, 0x24, 0xfd, 0xd0, 0xd0,
	0xed, 0x42, 0xaf, 0xc8, 0x0e, 0x5d, 0xda, 0x6a, 0x7f, 0xb4, 0x9f, 0x25, 0xd9, 0x78, 0x06, 0x77,
	0x7f, 0xf2, 0xa2, 0x30, 0x58, 0x18, 0x78, 0x03, 0x56, 0xc9, 0x9c, 0xb8, 0xf3, 0x1c, 0xe7, 0xd8,
	0xcd, 0xb3, 0xa8, 0x68, 0xdf, 0x27, 0x73, 0x72, 0xc2, 0xb0, 0xd3, 0x2c, 0x32, 0xf6, 0x00, 0x2d,
	0x13, 0x49, 0x8a, 0x74, 0xe8, 0x85, 0x84, 0xe3, 0x9c, 0xa3, 0xd8, 0xe5, 0x92, 0x55, 0xce, 0x31,
	0x21, 0xde, 0xeb, 0xf2, 0xa1, 0x94, 0x4b, 0xe3, 0x5f, 0x09, 0xa0, 0x1a, 0x30, 0xf4, 0x25, 0xac,
	0x79, 0x84, 0xe4, 0xe7, 0xd8, 0xcd, 0x92, 0x08, 0xf3, 0x59, 0x16, 0xed, 0x57, 0x05, 0x6c, 0x27,
	0x11, 0x66, 0x73, 0xfc, 0x09, 0xa8, 0x62, 0x83, 0xec, 0x0b, 0x21, 0xa9, 0x70, 0x80, 0x15, 0xa7,
	0x00, 0xec, 0x04, 0x84, 0x7a, 0x34, 0x27, 0xc5, 0x2b, 0x1c, 0x35, 0x9e, 0xf5, 0x19, 0xa7, 0xd9,
	0x2a, 0x99, 0x13, 0xf1, 0x13, 0x7d, 0x01, 0x03, 0xa1, 0xe5, 0x96, 0x87, 0x90, 0xc5, 0x9e, 0x04,
	0x7a, 0x24, 0xc0, 0x6a, 0x4f, 0xcc, 0xb4, 0x4e, 0x6d, 0x4f, 0xa7, 0x59, 0x84, 0x1e, 0xc3, 0x46,
	0x80, 0xbd, 0x20, 0xc2, 0x94, 0xe2, 0xcc, 0xad, 0xf6, 0x2e, 0x5e, 0x2a, 0xaa, 0x6a, 0x27, 0xe5,
	0x29, 0xae, 0x63, 0x30, 0xe5, 0xde, 0xb5, 0x0c, 0x76, 0x2b, 0x5f, 0x41, 0xbf, 0x96, 0xb4, 0x68,
	0x13, 0x94, 0xab, 0xec, 0x10, 0x26, 0x5e, 0xad, 0x8d, 0x6d, 0x58, 0x5d, 0x48, 0x52, 0xf4, 0x19,
	0xac, 0x2c, 0x24, 0x48, 0x71, 0xe9, 0xaf, 0xaa, 0xec, 0x78, 0x84, 0x41, 0xbd, 0xb2, 0x07, 0xf5,
	0xa1, 0x77, 0x3a, 0xfd, 0x71, 0xfa, 0xf2, 0xe7, 0xa9, 0x76, 0x07, 0x21, 0x18, 0x1c, 0x5b, 0x53,
	0x73, 0x7f, 0x3a, 0x71, 0x5f, 0xd8, 0xd6, 0xd8, 0xb1, 0xb4, 0x56, 0x1d, 0x33, 0xad, 0x43, 0xcb,
	0xb1, 0x34, 0x89, 0x91, 0x44, 0xdd, 0xd4, 0xda, 0x6c, 0x21, 0x0a, 0xa6, 0x26, 0x23, 0x15, 0x3a,
	0x96, 0x6d, 0xbf, 0xb4, 0xb5, 0xce, 0xa3, 0x37, 0x00, 0x55, 0x16, 0xa2, 0xfb, 0xb0, 0xee, 0x8c,
	0xed, 0x89, 0xe5, 0xb8, 0xce, 0xaf, 0xc7, 0x96, 0x5b, 0xf5, 0x5c, 0x87, 0xb5, 0x7a, 0x61, 0x76,
	0x32, 0xd3, 0x5a, 0x68, 0x03, 0xb4, 0x3a, 0xc8, 0xdc, 0xd0, 0x24, 0x74, 0x0f, 0x50, 0x1d, 0x3d,
	0x1c, 0x1f, 0xed, 0x98, 0x63, 0xad, 0xbd, 0xfd, 0x97, 0x0c, 0xbd, 0xe2, 0xfd, 0xa1, 0x4b, 0xe8,
	0x8a, 0xd4, 0x42, 0xdf, 0x35, 0x9b, 0x94, 0xa5, 0xbf, 0x13, 0x9b, 0x4f, 0x6f, 0x42, 0x23, 0x29,
	0xfa, 0xbb, 0x05, 0x1b, 0xd7, 0xe5, 0x00, 0xfa, 0xbe, 0x99, 0xe0, 0x7b, 0xe2, 0x67, 0xf3, 0x87,
	0xdb, 0xd0, 0x49, 0xca, 0x0c, 0x11, 0x19, 0xd9, 0xd4, 0x90, 0xa5, 0x68, 0x6e, 0x6a, 0xc8, 0x3b,
	0x41, 0xfc, 0x07, 0x28, 0x65, 0xb6, 0xa0, 0x67, 0xcd, 0x34, 0xde, 0x09, 0xb1, 0xcd, 0xe7, 0x37,
	0x23, 0x92, 0x74, 0xa7, 0xf3, 0x5b, 0x3b, 0x4b, 0xfd, 0xb3, 0x2e, 0xff, 0xa7, 0xec, 0xc9, 0xff,
	0x01, 0x00, 0x00, 0xff, 0xff, 0x63, 0xab, 0x94, 0xa8, 0xce, 0x09, 0x00, 0x00,
}
