#!/bin/bash

if [[ -z "$AWS_ACCESS_KEY_ID}" || -z "$AWS_SECRET_ACCESS_KEY" ]]; then
	echo "############################"
	echo "WARNING: running e2e without valid credentials to the e2e account"
	echo "is unlikely to work as intended."
	echo ""
	echo "Provide the AWS_ACCESS_KEY_ID et al env vars from e.g. isengard to run properly."
	echo "############################"
fi

E2E_FLAGS=""

while true; do
  case "$1" in
    --prompt-before-clean   ) export E2E_PROMPT_BEFORE_CLEAN="true" ; shift ;;
    --test-name             ) export E2E_TEST_NAME="$2"; shift; shift ;;
    * ) break ;;
  esac
done

docker-compose -p e2e -f docker-compose.e2e.yml up --exit-code-from e2e-test
