#!/bin/bash

QUEUE_NAME=$1

# Fake creds
export AWS_ACCESS_KEY_ID=foobar
export AWS_SECRET_ACCESS_KEY=foobar
export AWS_SESSION_TOKEN=foobar

if [[ "${QUEUE_NAME}" = "" ]]; then
  echo "Must provide a queue name argument: './local-create-queue.sh <queue_name>"
  exit 1
fi

aws --region us-east-1 --endpoint http://localhost:4566 sqs create-queue --queue-name ${QUEUE_NAME} --attributes '{"KmsMasterKeyId":"arn:aws:kms:us-west-2:000000000000:key/deadbeef","Policy":"{\"Version\":\"2012-10-17\",\"Statement\":[{\"Sid\":\"eventbus\",\"Effect\":\"Allow\",\"Principal\":\"*\",\"Action\":\"sqs:SendMessage\",\"Resource\": \"*\",\"Condition\":{\"ArnEquals\":{\"aws:SourceArn\":\"arn:aws:*:*:000000000000:*\"}}}]}"}'

