#!/bin/bash

EVENT_TYPE=$1
LDAP_GROUP=$2

if [[ "$2" == "" ]]; then
  LDAP_GROUP="team-eventbus"
fi

# Fake creds
export AWS_ACCESS_KEY_ID=foobar
export AWS_SECRET_ACCESS_KEY=foobar
export AWS_SESSION_TOKEN=foobar

if [[ "${EVENT_TYPE}" = "" ]]; then
  echo "Must provide an event type argument: './local-register-event-type.sh <event_type>"
  exit 1
fi

curl --request "POST" -s \
    --location "http://localhost:8888/twirp/code.justin.tv.eventbus.controlplane.infrastructure.Infrastructure/RegisterEventDefinitions" \
    --header "Content-Type:application/json" \
    --data "{\"event_definitions\":[{\"authorized_fields\":[{\"message_name\":\"Foobar\", \"field_name\":\"Garply\"}],\"ldap_group\":\"${LDAP_GROUP}\",\"event_type\": \"${EVENT_TYPE}\",\"display_name\":\"${EVENT_TYPE}\",\"schema\":\"syntax = "proto3";\n\npackage clock;\n\noption go_package = "clock";\n\nimport "eventbus/authorization.proto";\nimport "google/protobuf/timestamp.proto";\n\n// ${EVENT_TYPE} triggers when the time has changed by a second.\nmessage ${EVENT_TYPE} {\n  // The new time.\n  google.protobuf.Timestamp time = 1;\n  // The new time, in RFC3339 format. This field requires authorization to access.\n  eventbus.authorization.String secret_time = 2 [(eventbus.authorization.data_classification) = "restricted"];\n}\n\",\"repo_filepath\":\"events/clock/update.proto\"}]}" \
    --header "Twitch-Ldap-User: controlplane-updater" \
    --header "Twitch-Ldap-Groups: WyJjb250cm9scGxhbmUtdXBkYXRlciJd" # base64 encoded JSON groups (controlplane-updater)
