#!/bin/bash

# This script, when working with a fresh local environment, will setup the basic infra
# and some simple resources to have a working dashboard with decent data populated

# Run this using `make seed`

echo "Creating S3 bucket"
./scripts/local-seed-core-infra.sh

echo ""

echo "Registering some simple event types"
echo "  - FooBarCreate owned by team-foobar"
./scripts/local-register-event-type.sh FooBarCreate team-foobar > /dev/null
echo "  - FooBarUpdate owned by team-foobar"
./scripts/local-register-event-type.sh FooBarUpdate team-foobar > /dev/null
echo "  - FooBarDelete owned by team-foobar"
./scripts/local-register-event-type.sh FooBarDelete team-foobar > /dev/null
echo "  - MyCoolEvent owned by team-eventbus"
./scripts/local-register-event-type.sh MyCoolEvent team-eventbus > /dev/null
echo "  - ClockUpdate owned by team-eventbus"
./scripts/local-register-event-type.sh ClockUpdate team-eventbus > /dev/null
echo "  - StreamUpdate owned by team-coolpeople"
./scripts/local-register-event-type.sh StreamUpdate team-coolpeople > /dev/null

echo ""

echo "Creating IAM roles"
echo "  - $(./scripts/local-create-iam-role.sh role1 | jq -r '.Role.Arn')"
echo "  - $(./scripts/local-create-iam-role.sh role2 | jq -r '.Role.Arn')"
echo "  - $(./scripts/local-create-iam-role.sh role3 | jq -r '.Role.Arn')"
echo "  - $(./scripts/local-create-iam-role.sh role4 | jq -r '.Role.Arn')"
echo ""
echo "The above roles are not registered for you in the dashboard already, but they will pass validation when used!"
echo ""
echo "Creating SQS queues"
echo "  - $(./scripts/local-create-queue.sh eventbus-target1 | jq -r '.QueueUrl')"
echo "  - $(./scripts/local-create-queue.sh eventbus-target2 | jq -r '.QueueUrl')"
echo "  - $(./scripts/local-create-queue.sh eventbus-target3 | jq -r '.QueueUrl')"
echo "  - $(./scripts/local-create-queue.sh eventbus-target4 | jq -r '.QueueUrl')"
echo "  - $(./scripts/local-create-queue.sh invalid-target | jq -r '.QueueUrl')"
echo ""
echo "The above queues are not registered for you in the dashboard already, but they can be used!"
echo ""
echo "Done! Happy hacking!"