package services

import (
	"context"

	"github.com/aws/aws-sdk-go/service/kms"

	"code.justin.tv/eventbus/controlplane/internal/clients/ldap"
)

type EncryptionAtRestManager interface {
	GrantEncryptionAtRest(ctx context.Context, iamRoleARN string) (string, error)
	AllGrants(ctx context.Context) ([]*kms.GrantListEntry, error)
	FindByGrantID(ctx context.Context, grantID string) (*kms.GrantListEntry, error)
}

type CloudformationManager interface {
	GetVersion(ctx context.Context, awsAccountID string) (string, error)
}

type LDAPManager interface {
	UsersInGroup(groups string) ([]*ldap.User, error)
}
