package subscriptions

import (
	"strconv"

	"code.justin.tv/eventbus/controlplane/internal/db"
	"code.justin.tv/eventbus/controlplane/rpc"
)

func subToRPC(sub *db.Subscription, eventStream *db.EventStream) *rpc.Subscription {
	return &rpc.Subscription{
		TargetId:    strconv.Itoa(sub.SubscriptionTargetID),
		EventType:   eventStream.EventType.Name,
		Environment: eventStream.Environment,
		Status:      rpc.SubscriptionStatus(rpc.SubscriptionStatus_value[sub.Status]),
		Message:     sub.Error,
	}
}
