package targets

import "code.justin.tv/eventbus/controlplane/rpc"

type Status int

const (
	TargetIAMRoleARNRegex = `^arn:aws:iam::(\d+):(.)*\/(.)*`
	TargetNameMaxLength   = 128
	TargetNameMinLength   = 0
)

const (
	Unknown       Status = 0
	PendingCreate Status = 1
	PendingDelete Status = 2
	Created       Status = 3
	Deleted       Status = 4
	Error         Status = 5
)

func (s Status) DBString() string {
	return rpc.SQSStatus_name[int32(s)]
}

const DefaultRetentionProfile = "default"
