package targets

import (
	"strconv"

	"code.justin.tv/eventbus/controlplane/internal/db"
	"code.justin.tv/eventbus/controlplane/rpc"
)

func targetToRPC(target *db.SubscriptionTarget) *rpc.Target {
	rpcTarget := &rpc.Target{
		Id:        strconv.Itoa(target.ID),
		ServiceId: strconv.Itoa(target.ServiceID),
		Name:      target.Name,
	}

	rpcTarget.Details = &rpc.Target_Sqs{
		Sqs: &rpc.SQSDetails{
			AssumeRoleArn: target.AssumeRoleARN,
			QueueArn:      target.SQSDetails.SQSQueueARN,
			QueueUrl:      target.SQSDetails.SQSQueueURL,
			StatusMessage: target.Error,
			SqsStatus:     StatusCodeToEnum(target.Status),

			DeadletterQueueUrl: target.SQSDetails.DeadletterQueueURL,
			DeadletterQueueArn: target.SQSDetails.DeadletterQueueARN,
		},
	}

	return rpcTarget
}

func StatusCodeToEnum(status string) rpc.SQSStatus {
	switch status {
	case "PENDING_CREATE":
		return rpc.SQSStatus_PENDING_CREATE
	case "PENDING_DELETE":
		return rpc.SQSStatus_PENDING_DELETE
	case "CREATED":
		return rpc.SQSStatus_CREATED
	case "DELETED":
		return rpc.SQSStatus_DELETED
	case "ERROR":
		return rpc.SQSStatus_ERROR
	default:
		return rpc.SQSStatus_UNKNOWN
	}
}
