package targets

import (
	"testing"

	"code.justin.tv/eventbus/controlplane/rpc"
	"github.com/stretchr/testify/assert"
)

func TestStatuses(t *testing.T) {
	type input struct {
		S Status
		R rpc.SQSStatus
	}

	var tests = []input{
		{Unknown, rpc.SQSStatus_UNKNOWN},
		{PendingCreate, rpc.SQSStatus_PENDING_CREATE},
		{PendingDelete, rpc.SQSStatus_PENDING_DELETE},
		{Created, rpc.SQSStatus_CREATED},
		{Deleted, rpc.SQSStatus_DELETED},
		{Error, rpc.SQSStatus_ERROR},
	}

	for _, testcase := range tests {
		t.Run("case "+testcase.S.DBString(), func(t *testing.T) {
			if int32(testcase.R) != int32(testcase.S) {
				t.Errorf("%v != %v", testcase.R, testcase.S)
				t.FailNow()
			}
			assert.Equal(t, testcase.S.DBString(), testcase.R.String())

			// test the hand-written reversing function too
			assert.Equal(t, testcase.R, StatusCodeToEnum(testcase.R.String()))
		})
	}
}
