e dashboard
Dashboard for eventbus to peruse and subscribe to event streams

# Local Development

## Installing tools

1. Install `node` version `10.16.x`, preferrably using something like `nvm`: https://github.com/creationix/nvm
2. `npm install -g yarn@1.12.3`
3. `go get github.com/twitchtv/retool`
4. `make tools`
5. While on the Twitch VPN run `yarn install`

## Running Locally

The following setup instructions will get you to a place where you can run the dashboard locally in a hot-reloading environment

1. Check out the [Control Plane](https://git-aws.internal.justin.tv/eventbus/controlplane) repo and start it with `docker-compose up --build`
1. Edit your `/etc/hosts` file and add the line `127.0.0.1 localhost.internal.justin.tv`.
1. Set up an active Guardian session by visiting the [Service Catalog](https://servicecatalog.internal.justin.tv/)
1. In the dashboard directory run `yarn start` in one shell and `yarn server` in another

You can now access the dashboard at http://localhost.internal.justin.tv:8080/services

## Linting and Testing

`make lint`
`make test`

These are prerequisites for merging to master, so be sure these pass locally before pushing your branch.

## Frontend Testing

For running tests on your local, use `yarn test:watch`. This runs our frontend test suite in interactive mode.

We have two separate types of frontend tests: unit tests and snapshot tests. Snapshot tests serve as regression tests, and should primarily be used for testing small, simple, and presentational (stateless) components. For larger, more complicated, and stateful compoments, as well as for testing interactions with the user, use unit tests. Where possible, separate presentation from behavior - this makes it easier to test both.

[This](src/pages/services/components/edit-service-modal/editServiceModal.test.tsx) is an example of unit testing a large component.

[This](src/core/components/breadcrumbs/breadcrumbs.test.tsx) is an example of snapshot testing a small stateless component.

## Docker

Docker is set up to build a container in Jenkins which can be deployed to ECS. Part of the build requires that JS package dependencies are fetched from npm.internal.justin.tv. Because of this, builds will fail when running locally on a workstation. To enable working docker builds locally, you must install `twinit`, see instructions [here](https://wiki.twitch.com/display/DTA/Twinit+Services+Proxy+User+Guide).

Relevant docker `make` targets:
```
make docker-build
make docker-test
make docker-lint
```

## Jenkins

Builds: https://jenkins.internal.justin.tv/job/eventbus/job/dashboard/


