const replace = require('replace');

const args = process.argv.slice(2);
console.log(process.argv.slice(2));

if (args.length !== 3) {
  console.log('not enough arguments. Should be in the format of: ' +
    '\n `yarn initial-setup <team> <project> <aws-dev>`' +
    '\n e.g. `yarn initial-setup growth userlifecycleui twitch-growth-dev`');
  return;
}

const team = args[0];
const project = args[1];
const awsDev = args[2];

const baseOptions = {
  exclude: 'node_modules/*,node_modules/.cache/*,README.md,yarn.lock,yarn-error.log,Gopkg.toml,replace-config.js,dist/*',
  paths: ['.'],
  recursive: true,
};

replace({
  regex: "<team>",
  replacement: team,
  ...baseOptions,
});
replace({
  regex: "<project>|$project",
  replacement: project,
  ...baseOptions,
});
replace({
  regex: "\"name\": \"project\",",
  replacement: `\"name\": \"${project}\",`,
  include: 'package.json',
  ...baseOptions,
});
replace({
  regex: "<aws-dev>",
  replacement: awsDev,
  ...baseOptions,
});

return;