import { EventManagePage } from 'dashboard/pages/event-manage/components/event-manage-page';
import { EventCatalog } from 'dashboard/pages/events-catalog/components/events-catalog-page';
import { ServiceOverviewPage } from 'dashboard/pages/service-overview/components/service-overview-page';
import { ServicesPage } from 'dashboard/pages/services/components/services-page';
import { SubscriptionsPage } from 'dashboard/pages/subscriptions/components/subscriptions-page';
import * as React from 'react';
import { Redirect, Route, Switch } from 'react-router-dom';

export class DefaultRootRouter extends React.Component {
  public render() {
    return (
      <Switch>
        <Route exact path="/services" component={ServicesPage} />
        <Route exact path="/services/:id" component={ServiceOverviewPage} />
        <Route exact path="/events" component={EventCatalog} />
        <Route exact path="/events/:eventType" component={EventCatalog} />
        <Route exact path="/events/:eventType/manage" component={EventManagePage} />
        <Route
          exact
          path="/services/:serviceId/subscriptions/:targetId"
          component={SubscriptionsPage}
        />
        <Redirect path="/" to="/services" />
      </Switch>
    );
  }
}
