import * as React from 'react';
import { Pill, PillType } from 'twitch-core-ui';

interface EnvironmentPillProps {
    environment: string;
}
export const EnvironmentPill = ({ environment }: EnvironmentPillProps) => {
    let pillColor: PillType;
    if (environment === 'production') {
        pillColor = PillType.Brand;
    } else {
        pillColor = PillType.Overlay;
    }
    return (
        <Pill label={environment} type={pillColor} />
    );
};
