import * as React from 'react';
import { AlignItems, Color, CoreText, Display, JustifyContent, Layout, StyledLayout, SVG, SVGAsset, TextType } from 'twitch-core-ui';

interface Props {
  text: string;
}

export class Errored extends React.PureComponent<Props> {
  public render() {
    return (
      <StyledLayout
        padding={1}
        display={Display.Flex}
        justifyContent={JustifyContent.Center}
      >
        <Layout padding={1} alignItems={AlignItems.Center}>
          <SVG asset={SVGAsset.DeadGlitch}/>
        </Layout>
        <Layout padding={1} alignItems={AlignItems.Center}>
          <CoreText type={TextType.P} color={Color.Alt2} >{this.props.text}</CoreText>
        </Layout>
      </StyledLayout>
    );
  }
}
