import { code } from 'dashboard/generated/controlplane';
import * as React from 'react';
import * as ShallowRenderer from 'react-test-renderer/shallow';
import { EventStreamUsage } from './event-stream-usage';

import twirp = code.justin.tv.eventbus.controlplane;

it('renders with no values', () => {
  const renderer = ShallowRenderer.createRenderer();
  const event = new twirp.EventStream();
  jest.mock('dashboard/core/utils/event-stream', () => ({
    useEventStreamStats: {
      loading: false,
      error: null,
      maxEPM: null,
      minEPM: null,
      meanEPM: null,
      meanSize: null,
      publishers: new Array<twirp.IPublisherServiceInfo>(),
    },
    useEventTypeSubscribers: {
      loading: false,
      error: null,
      subscribers: new Array<twirp.IService>(),
    },
  }));
  const tree = renderer.render(<EventStreamUsage event={event} />);
  expect(tree).toMatchSnapshot();
});

it('renders with values', () => {
  const renderer = ShallowRenderer.createRenderer();
  const event = new twirp.EventStream();
  jest.mock('dashboard/core/utils/event-stream', () => ({
    useEventStreamStats: {
      loading: false,
      error: null,
      maxEPM: 123.456,
      minEPM: 234.567,
      meanEPM: 345.6789,
      meanSize: 11.22334455,
      publishers: [
        {
          name: 'service A',
          serviceCatalogUrl: 'https://catalog.xarth.tv/services/111/details',
        },
        {
          name: 'service B',
          serviceCatalogUrl: 'https://catalog.xarth.tv/services/222/details',
        },
      ],
    },
    useEventTypeSubscribers: {
      loading: false,
      error: null,
      subscribers: [
        {
          name: 'service C',
          serviceCatalogUrl: 'https://catalog.xarth.tv/services/333/details',
        },
        {
          name: 'service D',
          serviceCatalogUrl: 'https://catalog.xarth.tv/services/444/details',
        },
      ],
    },
  }));
  const tree = renderer.render(<EventStreamUsage event={event} />);
  expect(tree).toMatchSnapshot();
});
