import * as React from 'react';
import { AlignItems, CoreText, Display, FlexDirection, JustifyContent, Layout, SVG, SVGAsset, TextAlign } from 'twitch-core-ui';

interface ForbiddenProps {}

interface State {}

type Props = ForbiddenProps;

export class Forbidden extends React.Component<Props, State> {
    public state: State = {};

    constructor(props: Props) {
        super(props);
    }

    public render() {
        return (
            <Layout
                    display={Display.Flex}
                    flexDirection={FlexDirection.Column}
                    alignItems={AlignItems.Center}
                    justifyContent={JustifyContent.Center}
                    fullWidth
                    fullHeight
            >
                <Layout>
                    <CoreText bold >403</CoreText>
                </Layout>
                <Layout display={Display.Flex} flexDirection={FlexDirection.Row}>
                    <SVG height={40} width={40} asset={SVGAsset.Ban}/>
                    <Layout display={Display.Flex} justifyContent={JustifyContent.Center} textAlign={TextAlign.Center} alignItems={AlignItems.Center} margin={{ left: 2, right: 2 }}><CoreText italic >{this.pickQuote()}</CoreText></Layout>
                    <SVG height={40} width={40} asset={SVGAsset.Ban}/>
                </Layout>
            </Layout>
        );
    }

    private pickQuote(): string {
        const quotes = [
            '"The Magus denies you." - Rubick, DotA 2',
            '"From whence you came you shall remain, until you are complete again." - Jack Black, Tenacious D',
            '"Uh oh. Somebody cut the cake. I told them to wait for you, but they did it anyway. There is still some left, though, if you hurry back." - GLaDOS, Portal',
            '"Now would be a VERY good time to leave!" - Cortana, Halo',
        ];
        return quotes[Math.floor(Math.random() * (quotes.length))];
    }
}
